% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities_fsvdraws.R
\name{predcor}
\alias{predcor}
\title{Predicts correlation matrix}
\usage{
predcor(x, ahead = 1, each = 1)
}
\arguments{
\item{x}{Object of class \code{'fsvdraws'}, usually resulting from a call
to \code{\link{fsvsample}}.}

\item{ahead}{Vector of timepoints, indicating how many steps
to predict ahead.}

\item{each}{Single integer (or coercible to such) indicating how
often should be drawn from the posterior predictive distribution
for each draw that has been stored during MCMC sampling.}
}
\value{
4-dimensional array containing draws from the predictive
correlation distribution.
}
\description{
\code{predcor} simulates from the posterior predictive distribution
of the model-implied correlation matrix.
}
\note{
Currently crudely implemented as a triple loop in pure R,
may be slow.
}
\examples{
\donttest{
set.seed(1)
sim <- fsvsim(series = 3, factors = 1) # simulate
res <- fsvsample(sim$y, factors = 1) # estimate

# Predict 1, 10, and 100 days ahead:
predobj <- predcor(res, ahead = c(1, 10, 100))

# Trace plot of draws from posterior predictive distribution
# of the correlation of Sim1 and Sim2:
# (one, ten, and 100 days ahead):
plot.ts(predobj[1,2,,])

# Smoothed kernel density estimates of predicted covariance
# of Sim1 and Sim2:
plot(density(predobj[1,2,,"1"], adjust = 2))
lines(density(predobj[1,2,,"10"], adjust = 2), col = 2)
lines(density(predobj[1,2,,"100"], adjust = 2), col = 3)
}

}
\seealso{
Other predictors: 
\code{\link{predcond}()},
\code{\link{predcov}()},
\code{\link{predh}()},
\code{\link{predloglik}()},
\code{\link{predloglikWB}()},
\code{\link{predprecWB}()}
}
\concept{predictors}
