% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tabla.bidimensional.R
\name{tabla.bidimensional}
\alias{tabla.bidimensional}
\title{Tabla doble entrada.}
\usage{
tabla.bidimensional(
  x,
  var_filas = NULL,
  var_columnas = NULL,
  distribucion = c("cruzada", "condicionada"),
  frecuencias = c("absolutas", "relativas"),
  exportar = FALSE
)
}
\arguments{
\item{x}{Conjunto de datos. Tiene que ser un dataframe (al menos dos variables, es decir, dos columnas).}

\item{var_filas}{Variable fila.Por defecto su valor es NUll y el usuario debe escribir el nombre o posición de la variable cuyos valores quiere representar por filas.}

\item{var_columnas}{Variable columna. Por defecto su valor es NUll y el usuario debe escribir el nombre o posición de la variable cuyos valores quiere representar por columnas}

\item{distribucion}{Es un carácter. Por defecto se obtien la tabla cruzada (\code{distribucion = "cruzada"}). Para obtener las distribuciones condicionadas cambiar a \code{distribucion = "condicionada"}.}

\item{frecuencias}{Es un carácter. Por defecto se obtienen las frecuencias absolutas ordinarias (\code{frecuencias = "absolutas"}). Para obtener las frecuencias relativas ordinarias cambiar a \code{frecuencias = "relativas"}.}

\item{exportar}{Para exportar los resultados a una hoja de cálculo Excel (\code{exportar = TRUE}).}
}
\value{
Devuelve la tabla cruzada de las dos variables seleccionadas en un \code{data.frame}
}
\description{
Calcula la tabla de frecuencias bidimensionales.

Lee el código QR para video-tutorial sobre el uso de la función con un ejemplo.

\if{html}{\figure{qrtablabidimensional.png}{width = 200px}}
\if{latex}{\figure{qrtablabidimensional.png}{options: width=3cm}}
}
\references{
Esteban García, J. y otros. (2005). Estadística descriptiva y nociones de probabilidad. Paraninfo. ISBN: 9788497323741

Newbold, P, Carlson, W. y Thorne, B. (2019). Statistics for Business and Economics, Global Edition. Pearson. ISBN: 9781292315034

Murgui, J.S. y otros. (2002). Ejercicios de estadística Economía y Ciencias sociales. tirant lo blanch. ISBN: 9788484424673
}
\author{
\strong{Vicente Coll-Serrano}.
\emph{Métodos Cuantitativos para la Medición de la Cultura (MC2). Economía Aplicada.}

\strong{Rosario Martínez Verdú}.
\emph{Economía Aplicada.}

Facultad de Economía. Universidad de Valencia (España)
}
