% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oauth.R
\name{eg_oauth_app}
\alias{eg_oauth_app}
\title{Set Up OAuth Application Credentials}
\usage{
eg_oauth_app(
  domain,
  client_id,
  client_secret,
  redirect_uri = "https://localhost/callback"
)
}
\arguments{
\item{domain}{Your Egnyte domain (the subdomain of yourcompany.egnyte.com).}

\item{client_id}{The API key (client ID) from your registered application.}

\item{client_secret}{The client secret from your registered application.}

\item{redirect_uri}{The redirect URI configured for your app in the Egnyte
developer portal. Must be HTTPS. Defaults to \verb{https://localhost/callback}.}
}
\value{
Invisibly returns a list with the OAuth app configuration.
}
\description{
Configures the OAuth 2.0 application credentials for Egnyte authentication.
These credentials are obtained by registering your application at
\url{https://developers.egnyte.com}.
}
\details{
After registering at \url{https://developers.egnyte.com}, you will receive
a client_id and client_secret. Your application must be approved by Egnyte
before it becomes active.

\strong{Important:} You must configure the same redirect_uri in your Egnyte app
settings. Egnyte requires all redirect URIs to be HTTPS.

During development, your API key only works with your registered Egnyte
domain. After certification, it works with all Egnyte domains.
}
\examples{
\dontrun{
eg_oauth_app(
  domain = "mycompany",
  client_id = "your_client_id",
  client_secret = "your_client_secret",
  redirect_uri = "https://your-registered-redirect.com/callback"
)
}

}
\seealso{
\code{\link[=eg_oauth_authorize]{eg_oauth_authorize()}} to complete the OAuth flow.
}
