% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_sensitivity.R
\name{model_sensitivity}
\alias{model_sensitivity}
\title{Model Overall Sensitivity Scores Using Time Series Data}
\usage{
model_sensitivity(
  indicator_time_series,
  pressure_time_series,
  current_years = NULL,
  current_years_by_ind_press = NULL
)
}
\arguments{
\item{indicator_time_series}{a data frame containing only the state indicator
time series. First column MUST be the time column.}

\item{pressure_time_series}{a data frame containing only the pressure variables.
First column MUST be the time column.}

\item{current_years}{A vector with two numerics, specifying the time period for
the assessment period. The first one \code{start} is the starting year
for all pressure-indicator pairs and the second one \code{end} is the end of the
assessment period for all pressure-indicator pairs. The default is NULL.
One can specify pair specific assessment periods using the
\code{current_years_by_ind_press} argument.
If \code{current_years} and \code{current_years_by_ind_press} are NULL,
then the last 5 years of the time series are used as assessment period.}

\item{current_years_by_ind_press}{a data frame specifying for each indicator-pressure
pair the starting (third column) and end year (fourth column) where the
current conditions are best reflected. The default is NULL.
If \code{current_years} and \code{current_years_by_ind_press} are NULL,
then the last 5 years of the time series are used as assessment period.}
}
\value{
a data frame containing indicator, pressure, type of effect, the
sensitivity score and the associated uncertainty. Positive sensitivity scores
are associated with a positive influence of the pressure on the indicator and vice versa.
Additionally the R-squared, p-values, edf scores and the mean confidence
interval percentage, which are the basis of the scoring, are provided.
The type of effect is automatically set to\code{direct_indirect} as the model
cannot distinguish between direct and indirect effects.
If default settings are used, the following data frame will be returned:
\describe{
\item{\code{indicator}}{Name of the assessed state indicator.}
\item{\code{pressure}}{Name of the assessed pressure.}
\item{\code{type}}{Type of the assessed effect.}
\item{\code{pathway}}{The pathway that has been used to derive the sensitivity scores.}
\item{\code{sensitivity}}{Sensitivity score for the assessed state indicator-
pressure pair.}
\item{\code{adaptive_capacity}}{Adaptive capacity score for the assessed
state indicator-pressure pair, is automatically set to 0 and can be
changed afterwards.}
\item{\code{uncertainty_sens}}{uncertainty score associated with the sensitivity
scoring.}
\item{\code{uncertainty_ac}}{uncertainty score for adaptive capacity scoring.
Automatically set to NA, can be changed afterwards.}
\item{\code{r_sq}}{R-squared value of the GAM, used for the sensitivity scoring.}
\item{\code{p_value}}{P-value of the GAM, used to identify significant
relationships. Unsignificant relationships get a sensitivity score of 0.}
\item{\code{edf}}{Estimated degrees of freedom, used to assess non-linearity
of the relationship between state indicator and pressure. }
\item{\code{uncertainty_gam}}{Uncertainty score for sensitivity based on
predicted values from a GAM.}
\item{\code{uncertainty_arima}}{Uncertainty score for sensitivity based on
predicted values from an ARIMA using the pressure variable as external
predictor.}
}
}
\description{
The function \code{model_sensitivity()} uses time series of a state indicator and
a pressure variable to assess the state indicators sensitivity towards the
pressure. The relationship between pressure and state indicator is determined
using a generalized additive model (GAM). Uncertainty is evaluated with a GAM
and an ARIMA model. Use \code{\link{plot_diagnostic_sensitivity}} to review
model diagnostics of the applied GAM.
}
\details{
In case the relationship of one state indicator - pressure pair is not
significant the sensitivity score is 0, and thus also vulnerability and risk
will be 0. For a significant relationship the score will be set based on the
R-squared value from 1 (R-squared < 0.2) to 5 (R-squared >= 0.8). Additionally,
the function evaluates the edf score of the GAM which indicates the degree of
non-linearity in the relationship. Since highly non-linear relationships are
harder to predict, the risk of reaching an undesired state increases and the
sensitivity score for nonlinear relationships will be increased by 1
(if it was not 5 already). The direction of an effect (negative influence or
positive influence of the pressure) is evaluated with the slope of a linear
model representing the assessment period. If the slope of the linear model is
negative, the direction of effect is considered negative as well, and vice
versa for the positive effect.
The function assesses uncertainty associated with the scoring based on a
general additive model and an autoregressive integrated moving average model
(ARIMA). The ARIMA model uses the pressure variable as additional external predictor.
The models are fitted using the time series except the assessment period.
The assessment period is then predicted. The function evaluates how many of
the observed data points are within the predicted 95\% confidence interval.
If more than 66 \% are within the 95\% CI the uncertainty is 1 (low), if less
than 33 \% are within it, the uncertainty is set to 3 (high).
Additionally the function compares the mean size of the predicted 95\%
confidence interval and compares it to the maximum range of
the observed data points to account for very large confidence intervals, which
would otherwise lead to too optimistic uncertainty scores. The lower uncertainty
score is selected as final uncertainty score.

The function also creates columns to give the opportunity to assess adaptive
capacity and its associated uncertainty for each state indicator-pressure pair.
The scores for adaptive capacity and its associated uncertainty must be specified
before the next function \code{\link{vulnerability}} is applied (see examples).
If adaptive capacity and its uncertainty are not further specified, this will
influence the further application of the ecorisk framework.
}
\examples{
### Example with the 2 indicators and 8 pressure time series in the Baltic Sea demo data
#   where the last 7 years of the time series represent the current assessment period:
model_sensitivity(
  indicator_time_series = indicator_ts_baltic,
  pressure_time_series = pressure_ts_baltic,
  current_years = c(start = 2010, end = 2016)
)

### Example with the demo data but indicator-pressure-specific assessment periods:
sens_tbl <- model_sensitivity(
  indicator_time_series = indicator_ts_baltic,
  pressure_time_series = pressure_ts_baltic,
  current_years_by_ind_press = data.frame(
    ind = rep(names(indicator_ts_baltic)[-1], each = 8),
    press = rep(names(pressure_ts_baltic)[-1], 2),
    start = c(rep(2010, 8), rep(2008, 8)),
    end = c(rep(2016, 8), rep(2015, 8))
  )
)
# add the associated uncertainty (from 1 to 3, default is NA)
sens_tbl$adaptive_capacity <- c(0,0,1,1,1,1,-1,-1, -1,-1,1,1,1,1,1,-1)
sens_tbl$uncertainty_ac <- c(2,2,1,1,1,1,2,1, 3,3,1,1,2,2,3,1)
sens_tbl
}
\seealso{
\code{\link{model_exposure}}, \code{\link{vulnerability}}
}
