% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{ex_output_model_exposure}
\alias{ex_output_model_exposure}
\title{Example output from the \code{model_exposure()} function based on time series}
\format{
A data frame with 8 observations and 10 variables.
\describe{
\item{pressure}{Names of the assessed pressure.}
\item{exposure}{Combined exposure score (1 to 5).}
\item{uncertainty}{Uncertainty score from exposure modelling (1 to 3).}
\item{comp_magnitude}{Score for the magnitude or degree of change (1 to 5).}
\item{comp_frequency}{Score for the frequency or duration of change (1 to 5).}
\item{comp_trend}{Score for the current trend of change (1 to 5).}
\item{comp_direction}{Direction of the trend slope (increase or decrease).}
\item{comp_spatial}{Score for spatial extent of the pressure (default: 3; user-defined: 1 to 5).}
\item{uncertainty_arima}{Uncertainty score based on an ARIMA model.}
\item{uncertainty_gam}{Uncertainty score based on a GAM model.}
\item{mean_baseline}{Mean of the baseline conditions, used for
magnitude scoring.}
\item{mean_current}{Mean of the current conditions, used for magnitude
and frequency scoring.}
\item{standard_deviation_baseline}{Standard deviations of the baseline
conditions. Used for scoring of magnitude and frequency.}
\item{slope_linear_model}{Slope of the linear model used for scoring
the future trend and to determine the direction.}
\item{p_value_linear_model}{P-value of the linear model, used to
score the future trend.}
}
}
\usage{
ex_output_model_exposure
}
\description{
This dataset provides example output from the \code{\link{model_exposure}} function,
with component-specific exposure scores derived from the pressure time series
in \code{\link{pressure_ts_baltic}}. These scores are combined into an
overall exposure score, with associated uncertainties derived from two model types.
}
\keyword{datasets}
