% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ora.R
\name{plotGSEA}
\alias{plotGSEA}
\title{Visualization of GSEA Result from \code{\link[fgsea:fgsea]{fgsea::fgsea()}}}
\usage{
plotGSEA(fgseaRes, pathways, pwayname, stats, save = FALSE)
}
\arguments{
\item{fgseaRes}{A data table containing the GSEA results from the \code{fgsea} package.}

\item{pathways}{A list of all pathways used in the GSEA analysis.}

\item{pwayname}{The name of the pathway to visualize.}

\item{stats}{A numeric vector representing the ranked statistics.}

\item{save}{A logical value indicating whether to save the plot as a PDF file. Default is \code{FALSE}.}
}
\value{
ggplot2 object.
}
\description{
The \code{plotGSEA} function visualizes the results of a GSEA (Gene Set Enrichment Analysis) using data from
the \code{fgsea} package. It generates a composite plot that includes an enrichment plot and a ranked metric plot.
}
