% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ddbs_utils.R
\name{ddbs_create_conn}
\alias{ddbs_create_conn}
\title{Create a DuckDB connection with spatial extension}
\usage{
ddbs_create_conn(dbdir = "memory")
}
\arguments{
\item{dbdir}{String. Either \code{"tempdir"} or \code{"memory"}. Defaults to \code{"memory"}.}
}
\value{
A \code{duckdb_connection}
}
\description{
It creates a DuckDB connection, and then it installs and loads the
spatial extension
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
# load packages
library(duckspatial)

# create a duckdb database in memory (with spatial extension)
conn <- ddbs_create_conn(dbdir = "memory")

# create a duckdb database in disk  (with spatial extension)
conn <- ddbs_create_conn(dbdir = "tempdir")
\dontshow{\}) # examplesIf}
}
