% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dtms_backward.R
\name{dtms_backward}
\alias{dtms_backward}
\title{Carry states backward}
\usage{
dtms_backward(
  data,
  state,
  fromvar = "from",
  tovar = "to",
  statevar = NULL,
  idvar = "id",
  timevar = "time",
  dtms = NULL,
  overwrite = "missing",
  vector = FALSE
)
}
\arguments{
\item{data}{A data frame in long format.}

\item{state}{Character, name of the state to be carried forward.}

\item{fromvar}{Character (optional), name of variable with starting state. Default is `from`.}

\item{tovar}{Character (optional), name of variable with receiving state. Default is `to`.}

\item{statevar}{Character (optional), name of the variable in the data frame in long format with the states. Default is NULL.}

\item{idvar}{Character (optional), name of variable with unit ID. Default is `id`.}

\item{timevar}{Character (optional), name of variable with time scale. Default is `time`.}

\item{dtms}{dtms object (optional), as created with \code{dtms}. Not required if `overwrite==transient`.}

\item{overwrite}{Character (optional), one of `transient`, `missing`, `absorbing`, and `all`, see details. Default is `transient`.}

\item{vector}{Logical (optional), return vector (if TRUE) or data frame (if FALSE). Default is FALSE. Argument is only used if argument `statevar` is specified.}
}
\value{
The data frame specified with `data` and the edited state variable (if `vector=FALSE`) or a vector (if `vector=TRUE`).
}
\description{
This function carries a state backward after its last occurrence.
}
\details{
This function carries a state backward after its first occurrence.
For instance, carrying the state "A" backward in the sequence `B, B, A, B, B`
will give the sequence `A, A, A, B, B`. The sequence `C, B, C, A, B, A, A, B`
will give `A, A, A, A, A, A, A, B`.

This function works with data frames in transition format and in long format.
The default is transition format, using the arguments `fromvar` and `tovar`.
If, however, the argument `statevar` is specified, it is used instead.

The argument `overwrite` is used to control what type of information is
replaced. If `overwrite==transient`, then only transient states are replaced
while missing values and absorbing states remain unchanged. For example,
carrying backward state "A" in the sequence `B, NA, B, B, X, A, X` with X
being an absorbing state will give `A, NA, A, A, X, A, X`. If
`overwrite==missing` then in addition to transient states also missing values
are replaced and for the example sequence `A, A, A, A, X, A, X` would be
returned. If `overwrite==absorbing` then in addition to transient states
absorbing states will be replaced; for the example sequence the result would
be `A, NA, A, A, A, A, X`. Finally, if `overwrite==all` then all values in
the sequence will be replaced: `A, A, A, A, A, A, X`.
}
\examples{
simple <- dtms(transient=c("A","B"),
absorbing="X",
timescale=0:19)

dtms_backward(data=simpledata,
              statevar="state",
              state="A",
              dtms=simple,
              overwrite="transient")
}
\seealso{
\code{\link{dtms_forward}} to carry states forward.
}
