% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dtms_aggregate.R
\name{dtms_aggregate}
\alias{dtms_aggregate}
\title{Aggregate data}
\usage{
dtms_aggregate(data, weights = NULL, idvar = "id", countvar = "count")
}
\arguments{
\item{data}{Data frame.}

\item{weights}{Character (optional). Name of variable with weights.}

\item{idvar}{Character (optional). Name of variable in `data` with unit ID. Default is "id".}

\item{countvar}{Character (optional). Name of new variable in data which provides the counts. Default is "count".}
}
\value{
An aggregated data frame
}
\description{
This function takes any data set and returns a new data frame which only
includes the unique rows from the original data set and indicates how
often these rows appear in the original data.
}
\details{
Currently, missing values are not supported and will be dropped; consider
using factors if you want to keep them. The variable provided with the
argument `idvar` will be dropped from the aggregated data. If `weights` is
specified, the counts will be placed in a variable with the same name. If
`countvar` is used, any existing variable in the original data with the
same name will be replaced.
}
\examples{
## Define model: Absorbing and transient states, time scale
simple <- dtms(transient=c("A","B"),
               absorbing="X",
               timescale=0:20)
## Reshape to transition format
estdata <- dtms_format(data=simpledata,
                       dtms=simple,
                       idvar="id",
                       timevar="time",
                       statevar="state")
## Clean
estdata <- dtms_clean(data=estdata,
                      dtms=simple)
## Aggregate
aggdata <- dtms_aggregate(estdata)
## Fit model
fit <- dtms_fit(data=aggdata,
                weights="count")
}
