% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-summary.R
\name{get_summary_table}
\alias{get_summary_table}
\title{Generate Summary Table for a Data Table}
\usage{
get_summary_table(dt, cols = NULL)
}
\arguments{
\item{dt}{A data.table to summarize.}

\item{cols}{Optional character vector of column names to summarize. If
\code{NULL} (the default), all columns are summarized.}
}
\value{
A data.table with one row per column containing summary statistics.
}
\description{
Creates a comprehensive summary of all columns in a data.table, including
type, missing values, descriptive statistics, and example values.
}
\examples{
library(data.table)
dt <- data.table(
  id = 1:100,
  value = rnorm(100),
  category = sample(letters[1:5], 100, replace = TRUE)
)
get_summary_table(dt)
get_summary_table(dt, cols = c("value", "category"))

}
\seealso{
\code{\link[=summarize_vector]{summarize_vector()}} for single-vector summaries,
\code{\link[=diagnose_nas]{diagnose_nas()}} for missing value diagnostics
}
