% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_regression.R
\name{check_sibling_order_ram_optimized}
\alias{check_sibling_order_ram_optimized}
\title{Check Sibling Order RAM Optimized}
\usage{
check_sibling_order_ram_optimized(data, outcome, pair_identifiers, row)
}
\arguments{
\item{data}{The data set with kinship pairs}

\item{outcome}{A character string containing the outcome variable of
interest.}

\item{pair_identifiers}{A character vector of length two that contains the
variable identifier for each kinship pair. Default is c("_s1","_s2").}

\item{row}{The row number of the data frame}
}
\value{
A one-row data frame with a new column order indicating which familial member (1, 2, or
 neither) has more of the outcome.
}
\description{
This function determines the order of sibling pairs based on an outcome variable.
The function checks which of the two kinship pairs has more of a specified outcome variable.
It adds a new column named `order` to the dataset, indicating which sibling (identified as "s1" or "s2") has more of the outcome.
If the two siblings have the same amount of the outcome, it randomly assigns one as having more.
}
\keyword{internal}
