% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vecchia.R
\name{to_vec}
\alias{to_vec}
\title{Converts non-Vecchia object to its Vecchia version}
\usage{
to_vec(object, m = NULL, ord = NULL, cores = NULL)
}
\arguments{
\item{object}{object from \code{fit_one_layer}, \code{fit_two_layer}, or 
\code{fit_three_layer} with \code{vecchia = FALSE}}

\item{m}{size of Vecchia conditioning sets, defaults to the lower of 25 or 
maximum available}

\item{ord}{optional ordering for Vecchia approximation, defaults to random}

\item{cores}{number of cores to use for OpenMP parallelization.  Defaults 
to \code{min(4, maxcores - 1)} where \code{maxcores} is the number 
of detectable available cores.}
}
\value{
The same object, with \code{x_approx}, \code{w_approx}, and \code{z_approx}
        appended (depending on the number of layers).
}
\description{
Converts an object of class "gp", "dgp2", or "dgp3" to its 
             Vecchia equivalent ("gpvec", "dgp2vec", or "dgp3vec").
}
\details{
Creates and appends Vecchia-approximation objects to the 
    provided fit.  Defaults to random ordering and nearest neighbors
    conditioning.  Useful for speeding up predictions when the testing
    size is large but the training size is small.
}
\examples{
# See ?fit_one_layer for an example

}
