% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_character.R
\name{as_character}
\alias{as_character}
\alias{as_character.haven_labelled_defined}
\alias{as.character.haven_labelled_defined}
\title{Coerce a defined vector to character}
\usage{
as_character(x, ...)

\method{as_character}{haven_labelled_defined}(x, strip_attributes = TRUE, ...)

\method{as.character}{haven_labelled_defined}(x, ...)
}
\arguments{
\item{x}{A vector created with \code{\link[=defined]{defined()}}.}

\item{...}{Reserved for potential future use.}

\item{strip_attributes}{Logical; should semantic metadata attributes
(such as \code{label}, \code{unit}, \code{definition}, and
\code{namespace}) be removed from the returned vector?
Defaults to \code{FALSE}.}
}
\value{
A character vector (plain or with attributes).
}
\description{
\code{as_character()} is the recommended method to convert a
\code{\link[=defined]{defined()}} vector into a character vector. It is metadata-aware
and provides explicit control over whether semantic attributes are preserved.

Base R \code{as.character()} always strips the class and metadata.
}
\details{
If \code{preserve_attributes = TRUE}, the returned character vector retains
metadata attributes (\code{unit}, \code{concept}, \code{namespace}, \code{label}). The
\code{"defined"} class is always removed.

If \code{preserve_attributes = FALSE} (default), a plain character vector is
returned with \emph{all} metadata stripped.

Use \code{strip_attributes = TRUE} when flattening or preparing data for
external pipelines, but keep the default when working with defined
vectors directly.

Base R's \code{as.character()} always drops all attributes and returns plain
character values. It is equivalent to:
\code{as_character(x, strip_attributes = TRUE)}.
}
\examples{
x <- defined(c("apple", "banana"), label = "Fruit", unit = "kg")

# Recommended:
as_character(x)

# Preserve metadata:
as_character(x, strip_attributes = FALSE)

# Base R:
as.character(x)

}
