% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoenc_denoise_e.R
\name{autoenc_denoise_e}
\alias{autoenc_denoise_e}
\title{Denoising Autoencoder - Encode}
\usage{
autoenc_denoise_e(
  input_size,
  encoding_size,
  batch_size = 32,
  num_epochs = 1000,
  learning_rate = 0.001,
  noise_factor = 0.3
)
}
\arguments{
\item{input_size}{input size}

\item{encoding_size}{encoding size}

\item{batch_size}{size for batch learning}

\item{num_epochs}{number of epochs for training}

\item{learning_rate}{learning rate}

\item{noise_factor}{Numeric. Standard deviation (scale) of the noise added during training.}
}
\value{
A \code{autoenc_denoise_e} object.
}
\description{
Creates a deep learning denoising autoencoder (DAE) to encode sequences
while learning robustness to noise. Wraps a PyTorch implementation.
}
\examples{
\dontrun{
# 1) Prepare data
X <- matrix(rnorm(1000), nrow = 50, ncol = 20)

# 2) Fit denoising encoder (higher noise_factor = stronger noise during training)
ae <- autoenc_denoise_e(input_size = 20, encoding_size = 5, noise_factor = 0.2, num_epochs = 50)
ae <- daltoolbox::fit(ae, X)

# 3) Obtain latent encodings
Z <- daltoolbox::transform(ae, X)
dim(Z)
}

# See:
# https://github.com/cefet-rj-dal/daltoolbox/blob/main/autoencoder/autoenc_denoise_e.md
}
\references{
Vincent, P., Larochelle, H., Bengio, Y., & Manzagol, P. A. (2008). Extracting and Composing Robust Features with Denoising Autoencoders.
}
