% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/field_types.R
\name{template_field_types}
\alias{template_field_types}
\title{Print a template field_types() specification to console}
\usage{
template_field_types(df, default_field_type = ft_ignore())
}
\arguments{
\item{df}{data frame including the column names for the template
specification}

\item{default_field_type}{\code{field_type} to be used for each column. Default =
\code{\link[=ft_ignore]{ft_ignore()}}. See  \code{\link[=field_types_available]{field_types_available()}}}
}
\value{
(invisibly) Character string containing the template code
}
\description{
Helper function to generate template code for a \code{\link[=field_types]{field_types()}} specification,
based on the supplied data frame. All fields (columns) in the specification
will be defined using the \code{default_field_type}, and the console output can be
copied and edited before being used as input to \code{\link[=daiquiri_report]{daiquiri_report()}}
or \code{\link[=prepare_data]{prepare_data()}}.
}
\examples{
df <- data.frame(
  col1 = rep("2022-01-01", 5),
  col2 = rep(1, 5),
  col3 = 1:5,
  col4 = rnorm(5)
)

template_field_types(df, default_field_type = ft_numeric())
}
\seealso{
\code{\link[=field_types]{field_types()}}
}
