% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{internal_trapz}
\alias{internal_trapz}
\alias{cumtrapz}
\alias{trapz}
\title{Numerical integration using the trapezoidal rule}
\usage{
internal_trapz(x, y, return_cumsum = FALSE)

cumtrapz(x, y)

trapz(x, y)
}
\arguments{
\item{x}{numeric vector of strictly increasing x-values.}

\item{y}{numeric vector of function values at \code{x}.}

\item{return_cumsum}{logical, if \code{TRUE} return the cumulative integral at
each point in \code{x} (starting with 0), if \code{FALSE} return the total integral.}
}
\value{
\itemize{
\item \code{trapz()}: a single numeric value
\item \code{cumtrapz()}: numeric vector of cumulative integrals (starting with 0)
\item \code{internal_trapz()}: either of the above, depending on \code{return_cumsum}
}
}
\description{
These are internal helper functions to perform numerical integration
via the trapezoidal rule. The workhorse is \code{internal_trapz()}, which
computes the full integral or returns the cumulative integral.
}
\details{
\itemize{
\item \code{internal_trapz(x, y, return_cumsum = FALSE)}:
core implementation
\item \code{trapz(x, y)}
wrapper for \code{internal_trapz(x, y, FALSE)}, returns the total integral.
\item \code{cumtrapz(x, y)}
wrapper for \code{internal_trapz(x, y, TRUE)}, returns the cumulative integral.
}
}
\keyword{internal}
