% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot.traces_dm_list}
\alias{plot.traces_dm_list}
\alias{plot.traces_dm}
\title{Plot Traces of a Drift Diffusion Model}
\usage{
\method{plot}{traces_dm_list}(
  x,
  ...,
  conds = NULL,
  col = NULL,
  col_b = NULL,
  xlim = NULL,
  ylim = NULL,
  xlab = "Time",
  ylab = "Evidence"
)

\method{plot}{traces_dm}(x, ...)
}
\arguments{
\item{x}{an object of type \code{traces_dm_list} or \code{traces_dm}, containing the
traces to be plotted, resulting from a call to \code{\link[=simulate_traces]{simulate_traces()}}.}

\item{...}{additional graphical arguments passed to plotting functions.
See \code{\link[=set_default_arguments]{set_default_arguments()}} for the full list of supported
options.}

\item{conds}{a character vector specifying the conditions to plot.
Defaults to all available conditions.}

\item{col}{a character vector specifying colors for each condition. If a
single color is provided, it is repeated for all conditions.}

\item{col_b}{a character vector, specifying the color of the boundary for
each condition. If a single color is provided, it is repeated for all
conditions. Default is \code{"black"}.}

\item{xlim}{a numeric vector of length 2, specifying the x-axis limits.}

\item{ylim}{a numeric vector of length 2, specifying the y-axis limits.}

\item{xlab, ylab}{character strings for the x- and y-axis labels.}
}
\value{
\code{NULL} invisibly
}
\description{
Creates a plot of simulated traces (i.e., simulated evidence
accumulation processes) from a drift diffusion model. Such plots are useful
for exploring and testing model behavior.
}
\details{
\code{plot.traces_dm_list()} iterates over all conditions and plots the traces.
It includes a legend with condition labels.

\code{plot.traces_dm} plots a single set of traces. Because
\code{\link[=simulate_traces]{simulate_traces()}} returns an object of type \code{traces_dm_list} per
default, users will likely call \code{plot.traces_dm_list()} in most cases; and
not \code{plot.traces_dm}. \code{plot.traces_dm} is only relevant if users explicitly
extract and provide an object of type \code{traces_dm}.

The function automatically generates the upper and lower boundaries based on
the information stored within \code{x}.
}
\examples{
# get a couple of traces for demonstration purpose
a_model <- dmc_dm()
some_traces <- simulate_traces(a_model, k = 3)

# Plots for traces_dm_list objects ----------------------------------------
# basic plot
plot(some_traces)

# a slightly more beautiful plot :)
plot(some_traces,
  col = c("green", "red"),
  xlim = c(0, 0.35),
  xlab = "Time [s]",
  ylab = bquote(Realizations ~ of ~ X[t]),
  legend_pos = "bottomright"
)

# Plots for traces_dm objects ---------------------------------------------
# we can also extract a single set of traces and plot them
one_set_traces <- some_traces$comp
plot(one_set_traces)

# modifications to the plot work in the same way
plot(one_set_traces,
  col = "green",
  xlim = c(0, 0.35),
  xlab = "Time [s]",
  ylab = bquote(Realizations ~ of ~ X[t]),
  legend = "just comp"
)

}
\seealso{
\link{simulate_traces}
}
