% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_vcov.R
\name{cluster_vcov}
\alias{cluster_vcov}
\title{Cluster-robust variance-covariance for OLS}
\usage{
cluster_vcov(X, u, cluster, df_correction = TRUE, type = c("oneway", "twoway"))
}
\arguments{
\item{X}{Numeric design matrix (n x k) used in OLS.}

\item{u}{Numeric residual vector (length n).}

\item{cluster}{One of:
\itemize{
\item a vector (length n) of cluster ids for one-way clustering; or
\item a data.frame/list with two vectors (each length n) for two-way clustering.
}}

\item{df_correction}{Logical; apply small-sample corrections. Default \code{TRUE}.}

\item{type}{Character, one of \code{"oneway"} or \code{"twoway"}.}
}
\value{
A \code{k x k} variance-covariance matrix.
}
\description{
Computes one- or two-way cluster-robust vcov for an OLS design using the
Liang-Zeger "meat" and Cameron-Gelbach-Miller inclusion-exclusion for two-way clustering.
}
\keyword{internal}
