% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny.R
\name{countdown_app}
\alias{countdown_app}
\title{Launch Countdown Shiny App}
\usage{
countdown_app(...)
}
\arguments{
\item{...}{
  Arguments passed on to \code{\link[shiny:runApp]{shiny::runApp}}
  \describe{
    \item{\code{port}}{The TCP port that the application should listen on. If the
\code{port} is not specified, and the \code{shiny.port} option is set (with
\code{options(shiny.port = XX)}), then that port will be used. Otherwise,
use a random port between 3000:8000, excluding ports that are blocked
by Google Chrome for being considered unsafe: 3659, 4045, 5060,
5061, 6000, 6566, 6665:6669 and 6697. Up to twenty random
ports will be tried.}
    \item{\code{launch.browser}}{If true, the system's default web browser will be
launched automatically after the app is started. Defaults to true in
interactive sessions only. The value of this parameter can also be a
function to call with the application's URL.}
    \item{\code{host}}{The IPv4 address that the application should listen on. Defaults
to the \code{shiny.host} option, if set, or \code{"127.0.0.1"} if not. See
Details.}
    \item{\code{workerId}}{Can generally be ignored. Exists to help some editions of
Shiny Server Pro route requests to the correct process.}
    \item{\code{quiet}}{Should Shiny status messages be shown? Defaults to FALSE.}
    \item{\code{test.mode}}{Should the application be launched in test mode? This is
only used for recording or running automated tests. Defaults to the
\code{shiny.testmode} option, or FALSE if the option is not set.}
  }}
}
\value{
Runs the countdown timer Shiny app in the current R session.
}
\description{
Launches a full screen, interactive countdown timer as a
\link[shiny]{shiny-package} app.
}
\examples{
if (interactive()) {
  countdown_app()
}

}
\seealso{
Other Shiny functions: 
\code{\link{countdown_action}()},
\code{\link{countdown_shiny_example}()},
\code{\link{countdown_update}()}
}
\concept{Shiny functions}
