% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matcalc.R
\name{oddity}
\alias{oddity}
\title{Parity of a permutation}
\usage{
oddity(x)
}
\arguments{
\item{x}{A vector containing a permutation of the first
\eqn{n} integers, \eqn{1,2,\dots,n}.}
}
\value{
A real number equal to +1 or -1, indicating the
        parity of the given permutation.
}
\description{
Given a permutation of the integers from 1 to \eqn{n}, this
function calculates its parity (+1 or -1), i.e. the number
of swapping that take the permutation back to the natural
ordering \eqn{1,2,\dots,n}.
}
\examples{
# Identity permutation (10 elements)
x <- 1:10
print(oddity(x))

# One swap
x[2] <- 5
x[5] <- 2
print(oddity(x))

}
