% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/condition.R
\name{condition}
\alias{condition}
\alias{condition_progenitor}
\alias{condition_generator}
\alias{cnd::condition_progenitor}
\alias{cnd::condition_generator}
\alias{conditions}
\alias{cond}
\alias{cnd}
\alias{conditions<-}
\alias{conditions<-.function}
\alias{conditions<-.cnd::condition_progenitor}
\title{Conditions}
\usage{
condition(
  class,
  message = NULL,
  type = c("condition", "message", "warning", "error"),
  package = get_package(),
  exports = NULL,
  help = NULL,
  registry = package,
  register = !is.null(registry)
)

conditions(
  ...,
  class = NULL,
  type = NULL,
  package = NULL,
  registry = NULL,
  fun = NULL
)

cond(x)

cnd(condition)

conditions(x, ...) <- value

\method{conditions}{`function`}(x, append = FALSE, ...) <- value

\method{conditions}{`cnd::condition_progenitor`}(x, ...) <- value
}
\arguments{
\item{class}{The name of the new class}

\item{message}{The message to be displayed when the condition is called. When
entered as a character vector, the message is collapsed into a single
string. Use explicit line returns to generate new lines in output messages.
When a function is used and a character vector returned, each element is
treated as a new line.}

\item{type}{The type of condition: error, warning, or message}

\item{package}{The package to which the condition belongs}

\item{exports}{The exported functions to be displayed when the condition is
called}

\item{help}{The help message to be displayed for the condition function}

\item{registry}{The name of the registry to store the condition}

\item{register}{Controls registration checks}

\item{...}{Additional arguments passed to methods}

\item{fun}{if a function is passed, then retrieves the \code{"conditions"}
attribute}

\item{x}{An object}

\item{condition}{A \link{condition_generator} object}

\item{value}{A \code{condition}}

\item{append}{If \code{TRUE}, adds to the \strong{conditions} attribute}
}
\value{
\itemize{
\item \code{\link[=condition]{condition()}} a \link{condition_generator} object
}

\itemize{
\item \code{\link[=conditions]{conditions()}} a \code{list} of \link{condition_generator} objects
}

\itemize{
\item \code{\link[=cond]{cond()}} A \link{condition_generator} object
}

\itemize{
\item \code{\link[=cnd]{cnd()}} is a wrapper for calling \code{\link[=stop]{stop()}}, \code{\link[=warning]{warning()}}, or
\code{\link[=message]{message()}}; when  \code{condition} is a type, an error is thrown, and likewise
for the other types.  When an error isn't thrown, the \code{condition} is
returned, invisibly.
}
}
\description{
\code{\link[=condition]{condition()}} is used to create a new condition function
that itself returns a new \code{condition}.

\code{\link[=conditions]{conditions()}} retrieves all conditions based on search values.  The
parameters serve as filtering arguments.
}
\details{
Conditions
}
\section{\link{condition_generator}}{
 A \link{condition_generator} is an
object (a special \link{function}) which can be used to create generate a new
condition, based on specifications applied in \code{\link[=condition]{condition()}}. These
functions use \code{...} to absorb extra arguments and contain a special \code{.call}
parameter. By default, \code{.call} captures the parent call from where the
\link{condition_generator} was created, but users may pass their own call
to override this.  See \code{call.} in \code{\link[=conditionCall]{conditionCall()}}
}

\section{\code{\link[=condition]{condition()}} conditions}{


Conditions are generated through the \code{\link[=cnd-package]{\{cnd\}}} package.
The following conditions are associated with this function:

\describe{

\item{\code{\link[=cnd-cnd-conditions]{cnd:as_character_cnd_error/error}}}{
You cannot coerce a \link{condition_generator} object to a character. This may have occurred when trying to put a condition function through \code{\link[=stop]{stop()}} or \link{warning}.  Instead, call the function first, then pass the result to \code{\link[=stop]{stop()}} or \code{\link[=warning]{warning()}}.

For example:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{# Instead of this
stop(my_condition)

# Do this
stop(my_condition())
}\if{html}{\out{</div>}}

}

\item{\code{\link[=cnd-cnd-conditions]{cnd:condition_message_generator/error}}}{
\link{condition_generator} objects are not conditions.   You may have made this mistake:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{x <- condition("my_condition")
conditionMessage(x)
}\if{html}{\out{</div>}}

Condition generators need to be called first before they can be used as conditions.  Try this instead:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{x <- condition("my_condition")
conditionMessage(x())
}\if{html}{\out{</div>}}

}

\item{\code{\link[=cnd-cnd-conditions]{cnd:condition_overwrite/warning}}}{
Defining a new condition with the same class and package as an existing condition will overwrite the previous definition.  It is recommended to either avoid this by fully defining your condition, or creating a new condition instead.
}

\item{\code{\link[=cnd-cnd-conditions]{cnd:invalid_condition/error}}}{
The \code{class}, \code{exports}, and \code{help} parameters must be a single character string.  If you are passing a function, it must be a valid function.
}

\item{\code{\link[=cnd-cnd-conditions]{cnd:invalid_condition_message/error}}}{
Conditions messages are displayed when invoked through \code{\link[=conditionMessage]{conditionMessage()}}.  You can set a static message by passing through a \code{character} vector, or a dynamic message by passing through a \code{function}.  The function should return a \code{character} vector.

When \code{message} is not set, a default "there was an error" message is used.
}

\item{\code{\link[=cnd-cnd-conditions]{cnd:match_arg/error}}}{
Mostly \code{\link[=match.arg]{match.arg()}} but with a custom condition
}

\item{\code{\link[=cnd-cnd-conditions]{cnd:no_package_exports/warning}}}{
The \code{exports} parameter requires a \code{package}
}

}

For more conditions, see: \link{cnd-cnd-conditions}
}

\section{\code{\link[=cnd]{cnd()}} conditions}{


Conditions are generated through the \code{\link[=cnd-package]{\{cnd\}}} package.
The following conditions are associated with this function:

\describe{

\item{\code{\link[=cnd-cnd-conditions]{cnd:cond_cnd_class/error}}}{
\code{\link[=cnd]{cnd()}} simple calls the appropriate function: \code{\link[=stop]{stop()}}, \code{\link[=warning]{warning()}}, or \code{\link[=message]{message()}} based on the \code{type} parameter from \code{\link[=condition]{condition()}}.
}

}

For more conditions, see: \link{cnd-cnd-conditions}
}

\examples{
# create a new condition:
cond_bad_value <- condition("bad_value", type = "error")

# use the condition
try(stop(cond_bad_value()))
try(cnd(cond_bad_value()))

# dynamic messages:
cond_class_error <- condition(
  "class_error",
  message = function(x) paste("class cannot be", toString(class(x))),
  type = "error"
)
try(stop(cond_class_error(list())))

}
\seealso{
\link{cnd-package}
}
