% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/priors.R
\name{flat}
\alias{flat}
\title{Flat (Improper Uniform) Prior Distribution}
\usage{
flat()
}
\value{
An object of class \code{"clm_dist"} representing a flat distribution.
}
\description{
Creates a flat (improper uniform) distribution object for use with \code{\link[=prior]{prior()}}.
A flat prior assigns equal probability density to all values, which is
improper (does not integrate to 1) but can be used when the likelihood
provides sufficient information for identification.
}
\note{
Flat priors are supported for:
\itemize{
\item Regression coefficients (class "b")
\item Threshold classes ("Intercept", "c1", "cpos")
}
Using flat priors may lead to improper posteriors if the likelihood
does not provide sufficient information. For thresholds with ordered
constraints, Stan's internal transformation provides implicit regularization.
}
\examples{
# Create a flat prior for regression coefficients
prior(flat(), class = "b")

# Flat prior for thresholds (flexible)
prior(flat(), class = "Intercept")
}
\seealso{
\code{\link[=prior]{prior()}}, \code{\link[=normal]{normal()}}, \code{\link[=student_t]{student_t()}}, \code{\link[=cauchy]{cauchy()}}
}
