% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cits_plot_counterfactual.R
\name{plot_cits_result_cf}
\alias{plot_cits_result_cf}
\title{CITS Automatic Analysis and Counterfactual Visualization}
\usage{
plot_cits_result_cf(
  res,
  y_col = "y",
  T_col = "T",
  I_col = "I",
  E_col = "E",
  intervention_time
)
}
\arguments{
\item{res}{A list returned by `cits()`, containing model output and fitted values.}

\item{y_col}{Name of the outcome variable (string). Corresponds to `y` in `cits()`.}

\item{T_col}{Name of the time index variable (string). Corresponds to `T` in `cits()`.}

\item{I_col}{Name of the intervention indicator variable (string). Corresponds to `I` in `cits()`.}

\item{E_col}{Name of the group indicator variable (string). Corresponds to `E` in `cits()`.}

\item{intervention_time}{Numeric. Time point at which the intervention occurs.}
}
\value{
A ggplot object showing observed points, fitted lines, confidence ribbons,
        a counterfactual trajectory for the treatment group, and an intervention marker.
}
\description{
Visualizes the results of a controlled interrupted time series (CITS) model
fitted using `cits()`, and generates a counterfactual trajectory for the
treatment group (E = 1) by setting the intervention indicator (`I`) to 0
after the intervention time. The function displays observed points, fitted
values, 95% confidence intervals, and a dashed counterfactual line, along
with a vertical marker for the intervention.
}
\examples{
df <- data.frame(
  T = 1:100,
  E = rep(c(0,1), each = 100),
  I = c(rep(0,50), rep(1,50), rep(0,50), rep(1,50)),
  y = rnorm(200)
)

# Use lightweight ARMA search for examples (CRAN speed requirement)
res <- cits(
  df,
  y_col = "y",
  T_col = "T",
  I_col = "I",
  E_col = "E",
  p_range = 0:1,
  q_range = 0:0
)

plot_cits_result_cf(res, intervention_time = 10)

}
