% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prep_scATAC_seurat.R
\name{prep_scATAC_seurat}
\alias{prep_scATAC_seurat}
\title{prep_scATAC_seurat}
\usage{
prep_scATAC_seurat(
  object,
  assay = NULL,
  slot = "counts",
  sample.col,
  group.col,
  cluster.col = NULL,
  peak.bed = NULL,
  min.cells = 20,
  verbose = TRUE
)
}
\arguments{
\item{object}{Seurat object containing an ATAC assay (typically "peaks").}

\item{assay}{assay name to use; defaults to Seurat::DefaultAssay(object).}

\item{slot}{assay slot to pull counts from (default "counts").}

\item{sample.col}{column name in object@meta.data indicating biological replicate.}

\item{group.col}{column name in object@meta.data indicating condition/group.}

\item{cluster.col}{optional column name for cell type/cluster.}

\item{peak.bed}{optional data.frame with CHR/START/STOP columns for peaks.}

\item{min.cells}{minimum number of cells required per sample (and per cluster if used).}

\item{verbose}{logical, prints informative messages.}
}
\value{
list with elements `bed`, `contrasts`, and `group.info`, or a named list
of such lists when cluster.col is provided.
}
\description{
Prepare 10x scATAC data from a Seurat/Signac object for cinaR.
}
\examples{
\dontrun{
prep <- prep_scATAC_seurat(seurat_obj,
                           sample.col = "sample",
                           group.col = "group",
                           assay = "peaks")
}
}
