% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/temp_models.R
\name{DynModel_driver}
\alias{DynModel_driver}
\title{DynModel_driver}
\usage{
DynModel_driver(
  temp,
  times,
  A0 = 139500,
  A1 = 2.567e+18,
  E0 = 4153.5,
  E1 = 12888.8,
  slope = 1.6,
  Tf = 4,
  deg_celsius = TRUE
)
}
\arguments{
\item{temp}{Vector of temperatures.}

\item{times}{numeric vector. Optional times at which the temperatures where measured,
if not given, hourly temperatures will be assumed}

\item{A0}{numeric. Parameter \eqn{A_0}{A0} of the dynamic model}

\item{A1}{numeric. Parameter \eqn{A_1}{A1} of the dynamic model}

\item{E0}{numeric. Parameter \eqn{E_0}{E0} of the dynamic model}

\item{E1}{numeric. Parameter \eqn{E_1}{E1} of the dynamic model}

\item{slope}{numeric. Slope parameter for sigmoidal function}

\item{Tf}{numeric. Transition temperature (in degree Kelvin) for the
sigmoidal function}

\item{deg_celsius}{boolean. whether or not the temperature vector
and the model temperature parameters are
in degree Celsius (Kelvin otherwise)}
}
\value{
List containint four vectors of length(temp) with elements
\code{x} is the PDBF, \code{y} the accumulated chill, \code{delta} the
chill portions and \code{xs}, which is
\eqn{x_s=A_0/A_1\exp(-(E_0-E_1)/T)}{xs=A0/A1\exp(-(E0-E1)/T}
Portions over the entire duration of HourTemp.
}
\description{
Calculation of cumulative chill according to the Dynamic Model

This function calculates winter chill for temperate trees according to the
Dynamic Model.

Chill Portions are calculated as suggested by Erez et al. (1990).
}
\details{
This function gives idential results as \link{Dynamic_Model} for hourly
temperature data, returns more details but is also a bit slower in the R code
version
}
\examples{

weather<-fix_weather(KA_weather[which(KA_weather$Year>2006),])
hourtemps<-stack_hourly_temps(weather,latitude=50.4)
res2 <- DynModel_driver(temp=hourtemps$hourtemps$Temp)

}
\references{
Dynamic Model references:

Erez A, Fishman S, Linsley-Noakes GC, Allan P (1990) The dynamic model for
rest completion in peach buds. Acta Hortic 276, 165-174

Fishman S, Erez A, Couvillon GA (1987a) The temperature dependence of
dormancy breaking in plants - computer simulation of processes studied under
controlled temperatures. J Theor Biol 126(3), 309-321

Fishman S, Erez A, Couvillon GA (1987b) The temperature dependence of
dormancy breaking in plants - mathematical analysis of a two-step model
involving a cooperative transition. J Theor Biol 124(4), 473-483
}
\author{
Carsten Urbach <urbach@hiskp.uni-bonn.de>
}
\keyword{and}
\keyword{calculation}
\keyword{chill}
\keyword{heat}
