% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io_helpers.R
\name{set_grouping_var}
\alias{set_grouping_var}
\title{Set grouping variables}
\usage{
set_grouping_var(mode, doc_groups, label_groups, var = NULL)
}
\arguments{
\item{mode}{One of the following aggregation modes: \code{"doc-avg",
"subj-avg", "micro"}.}

\item{doc_groups}{A two-column data.frame with a column \code{"doc_id"} and a
second column defining groups of documents to stratify results by. It is
recommended that groups are of type factor so that levels are not
implicitly dropped during bootstrap replications.}

\item{label_groups}{A two-column data.frame with a column \code{"label_id"}
and a second column defining groups of labels to stratify results by.
Results in each stratum will restrict gold standard and predictions to the
specified label groups as if the vocabulary was consisting of the label
group only. All modes \code{"doc-avg", "subj-avg", "micro"} are supported
within label strata. Nevertheless, mixing \code{mode = "doc-avg"} with
fine-grained label strata can result in many missing values on
document-level results. Also rank-based thresholding (e.g. top 5) will
result in inhomogeneous numbers of labels per document within the defined
label strata. \code{mode = "subj-avg"} or \code{mode = "micro"} can be more
appropriate in these circumstances.}

\item{var}{Additional variables to include.}
}
\value{
A character vector of variables determining the grouping structure.
}
\description{
Determine the appropriate grouping variables for each aggregation mode.
}
