% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adapt_dwd.R
\name{dwd_coast_warnings}
\alias{dwd_coast_warnings}
\title{Fetch DWD coastal warnings}
\usage{
dwd_coast_warnings(
  language = c("de", "en"),
  safe = TRUE,
  refresh = FALSE,
  flatten = FALSE,
  flatten_mode = "json"
)
}
\arguments{
\item{language}{Language code ("de" or "en").}

\item{safe}{Logical; apply throttling and caching.}

\item{refresh}{Logical; refresh cached responses.}

\item{flatten}{Logical; drop nested list columns.}

\item{flatten_mode}{Flatten strategy for list columns. Use "unnest" to
expand list-columns into multiple rows.}
}
\value{
A tibble with coastal warnings.
}
\description{
Fetch DWD coastal warnings
}
\details{
Retrieves coastal warnings from the DWD App API.
Official docs: https://dwd.api.bund.dev.
}
\examples{
\dontrun{
dwd_coast_warnings(language = "de", flatten = TRUE)
}

}
\seealso{
\code{\link[=dwd_warnings_nowcast]{dwd_warnings_nowcast()}} and \code{\link[=dwd_municipality_warnings]{dwd_municipality_warnings()}}.
}
