% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tool-docs-news.R
\name{btw_tool_docs_package_news}
\alias{btw_tool_docs_package_news}
\title{Tool: Package Release Notes}
\usage{
btw_tool_docs_package_news(package_name, search_term = "", `_intent` = "")
}
\arguments{
\item{package_name}{The name of the package as a string, e.g. \code{"shiny"}.}

\item{search_term}{A regular expression to search for in the NEWS entries.
If empty, the release notes of the current installed version is included.}

\item{_intent}{An optional string describing the intent of the tool use.
When the tool is used by an LLM, the model will use this argument to
explain why it called the tool.}
}
\value{
Returns the release notes for the currently installed version of the
package, or the release notes matching the search term.
}
\description{
Include release notes for a package, either the release notes for the most
recent package release or release notes matching a search term.
}
\examples{
\dontshow{if (rmarkdown::pandoc_available()) withAutoprint(\{ # examplesIf}
# Copy release notes to the clipboard for use in any AI app
btw("@news dplyr", clipboard = FALSE)

btw("@news dplyr join_by", clipboard = FALSE)

if (interactive()) { # can be slow
  if (R.version$major == 4 && R.version$minor > "2.0") {
    # Search through R's release notes.
    # This should find a NEWS entry from R 4.2
    btw("@news R dynamic rd content", clipboard = FALSE)
  }
}

# Tool use by LLMs via ellmer or MCP ----
btw_tool_docs_package_news("dplyr")

btw_tool_docs_package_news("dplyr", "join_by")
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=btw_tools]{btw_tools()}}

Other docs tools: 
\code{\link{btw_tool_package_docs}}
}
\concept{docs tools}
