% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tool-git.R
\name{btw_tool_git_branch_list}
\alias{btw_tool_git_branch_list}
\title{Tool: Git Branch List}
\usage{
btw_tool_git_branch_list(include = c("local", "remote", "all"), `_intent` = "")
}
\arguments{
\item{include}{Once of \code{"local"} (default), \code{"remote"}, or \code{"all"} to filter
branches to local branches only, remote branches only, or all branches.}

\item{_intent}{An optional string describing the intent of the tool use.
When the tool is used by an LLM, the model will use this argument to
explain why it called the tool.}
}
\value{
Returns a character table of branches.
}
\description{
This tool allows an LLM to list git branches in the repository using
\code{\link[gert:git_branch]{gert::git_branch_list()}}, equivalent to \verb{git branch} in the terminal.
}
\examples{
\dontshow{if (rlang::is_installed("gert")) withAutoprint(\{ # examplesIf}
withr::with_tempdir({
  gert::git_init()
  gert::git_config_set("user.name", "R Example")
  gert::git_config_set("user.email", "ex@example.com")

  fs::file_touch("hello.md")
  gert::git_add("hello.md")
  gert::git_commit("Initial commit")

  gert::git_branch_create("feature-1")
  gert::git_branch_create("feature-2")

  # What the LLM sees
  cat(btw_tool_git_branch_list()@value)
})
\dontshow{\}) # examplesIf}
}
\seealso{
Other git tools: 
\code{\link{btw_tool_git_branch_checkout}()},
\code{\link{btw_tool_git_branch_create}()},
\code{\link{btw_tool_git_commit}()},
\code{\link{btw_tool_git_diff}()},
\code{\link{btw_tool_git_log}()},
\code{\link{btw_tool_git_status}()}
}
\concept{git tools}
