% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph_relationships.R
\name{bs_get_relationships}
\alias{bs_get_relationships}
\title{Get relationships between an account and other users}
\usage{
bs_get_relationships(
  actor,
  others,
  user = get_bluesky_user(),
  pass = get_bluesky_pass(),
  auth = bs_auth(user, pass),
  clean = TRUE
)
}
\arguments{
\item{actor}{Character, length 1. name of 1 actor, such as \code{'chriskenny.bsky.social'}}

\item{others}{Optional, character vector of other users to look up relationships}

\item{user}{Character. User name to log in with. Defaults to \code{get_bluesky_user()}.}

\item{pass}{Character. App password to log in with. Defaults to \code{get_bluesky_pass()}.}

\item{auth}{Authentication information. Defaults to \code{bs_auth(user, pass)}.}

\item{clean}{Logical. Should output be cleaned into a \code{tibble}? Default: \code{TRUE}.}
}
\value{
a \link[tibble:tibble]{tibble::tibble} of relationships
}
\description{
Get relationships between an account and other users
}
\section{Lexicon references}{

\href{https://github.com/bluesky-social/atproto/blob/main/lexicons/app/bsky/graph/getRelationships.json}{graph/getRelationships.json (2024-12-01)}
}

\section{Function introduced}{

\code{v0.2.0} (2024-12-01)
}

\examples{
\dontshow{if (has_bluesky_pass() && has_bluesky_user()) withAutoprint(\{ # examplesIf}
bs_get_relationships('chriskenny.bsky.social', 'bskyr.bsky.social')
\dontshow{\}) # examplesIf}
}
\concept{graph}
