% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_selic_rate.R
\name{plot_selic_rate}
\alias{plot_selic_rate}
\title{Plot Brazilian SELIC rate (annualized, base 252)}
\usage{
plot_selic_rate(data, language = "eng")
}
\arguments{
\item{data}{Tibble returned by \code{get_selic_rate()}}

\item{language}{Language for titles and labels: "pt" (Portuguese) or "eng" (English).}
}
\value{
A \code{ggplot2} object showing the SELIC rate over time.
}
\description{
Generates a time series plot of the SELIC interest rate using data from \code{get_selic()}.
The SELIC rate ("Sistema Especial de Liquidação e de Custódia") represents the
effective annualized rate (252-business-day basis) for overnight interbank loans
and is the main instrument of Brazil’s monetary policy.
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
# Example 1: English version
selic_data <- get_selic_rate(2020, 2024)
selic_plot <- plot_selic_rate(selic_data)
print(selic_plot)

# Example 2: Portuguese version
dados_selic <- get_selic_rate(2020, 2024, language = "pt")
grafico_selic <- plot_selic_rate(dados_selic, language = "pt")
print(grafico_selic)
\dontshow{\}) # examplesIf}
}
