% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_cdi_rate.R
\name{get_cdi_rate}
\alias{get_cdi_rate}
\title{Get CDI Rate (Interbank Deposit Certificate)}
\usage{
get_cdi_rate(
  start_date = NULL,
  end_date = NULL,
  language = "eng",
  labels = TRUE
)
}
\arguments{
\item{start_date}{Start date for the data period. Accepts multiple formats:
\itemize{
\item \code{"YYYY"} for year only (e.g., \code{"2020"} becomes \code{"2020-01-01"})
\item \code{"YYYY-MM"} for year and month (e.g., \code{"2020-06"} becomes \code{"2020-06-01"})
\item \code{"YYYY-MM-DD"} for a specific date (e.g., \code{"2020-06-15"})
}}

\item{end_date}{End date for the data period. Accepts the same formats as \code{start_date}:
\itemize{
\item \code{"YYYY"} (e.g., \code{"2023"} becomes \code{"2023-12-31"})
\item \code{"YYYY-MM"} (e.g., \code{"2023-12"} becomes the last day of December 2023)
\item \code{"YYYY-MM-DD"} for a specific date
\item \code{NULL} defaults to the current date (today)
}}

\item{language}{Language for column names in the returned data.frame:
\itemize{
\item \code{"eng"} (default): Returns columns \code{date} and \code{cdi_rate}
\item \code{"pt"}: Returns columns \code{data_referencia} and \code{taxa_cdi}
}}

\item{labels}{Logical indicating whether to add variable labels using the \code{labelled}
package. Labels provide descriptive text for each column when available.}
}
\value{
A data.frame with columns:
\describe{
\item{date}{Reference date}
\item{value}{Daily CDI rate (\% per day)}
\item{value_annualized}{Annualized CDI rate (\% per year, 252 business days)}
}
}
\description{
Downloads daily CDI (Certificado de Depósito Interbancário) rate from BCB/SGS.
This function retrieves the daily CDI rate (SGS series 12), which is the benchmark
interest rate for interbank transactions in Brazil.
}
\note{
\strong{Series information}: This function uses SGS series 12, which represents the
daily CDI rate (taxa de juros - CDI). The CDI is a key benchmark for fixed income
investments and interbank lending in Brazil. Data is available from 1986 onward
with daily frequency (business days only).
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
  # Default: last 30 days of CDI rate
  df <- get_cdi_rate()

  # Specific period
  df2 <- get_cdi_rate("2023-01-01", "2023-03-31")

  # Using year-month format for a specific month
  df3 <- get_cdi_rate("2023-06", "2023-06")

  # Portuguese column names and labels
  df4 <- get_cdi_rate(language = "pt")

  # Complete example with all parameters
  df5 <- get_cdi_rate("2023-01-01", "2023-12-31", language = "pt", labels = TRUE)

  # Historical analysis
  df6 <- get_cdi_rate("2020-03-01", "2020-04-30")  # COVID period
\dontshow{\}) # examplesIf}
}
