% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/centr_lev.R
\name{centr_lev}
\alias{centr_lev}
\title{Calculate a vertex's leverage centrality}
\usage{
centr_lev(g, A = NULL)
}
\arguments{
\item{g}{An \code{igraph} graph object}

\item{A}{Numeric matrix; the adjacency matrix of the input graph. Default:
\code{NULL}}
}
\value{
A vector of the leverage centrality for all vertices.
}
\description{
Calculates the leverage centrality of each vertex in a graph.
}
\details{
The leverage centrality relates a vertex's degree with the degree of its
neighbors. The equation is:
\deqn{l_i = \frac{1}{k_i} \sum_{j \in N_i} \frac{k_i - k_j}{k_i + k_j}}
where \eqn{k_i} is the degree of the \eqn{i^{th}} vertex and \eqn{N_i} is the
set of neighbors of \emph{i}. This function replaces \emph{NaN} with
\emph{NA} (for functions that have the argument \emph{na.rm}).
}
\references{
Joyce, K.E. and Laurienti P.J. and Burdette J.H. and Hayasaka S.
(2010) A new measure of centrality for brain networks. \emph{PLoS One},
\bold{5(8)}, e12200. \doi{10.1371/journal.pone.0012200}
}
\seealso{
Other Centrality functions: 
\code{\link{centr_betw_comm}()}
}
\author{
Christopher G. Watson, \email{cgwatson@bu.edu}
}
\concept{Centrality functions}
