% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_corr.R
\name{plot_corr}
\alias{plot_corr}
\title{Create Simple Professional Correlation Matrix Plots}
\usage{
plot_corr(
  data,
  vars = NULL,
  method = c("pearson", "spearman"),
  type = c("full", "upper", "lower"),
  colors = NULL,
  title = NULL,
  show_values = TRUE,
  value_size = 3,
  show_sig = FALSE,
  sig_level = 0.05,
  sig_only = FALSE,
  show_legend = TRUE,
  p_method = "holm"
)
}
\arguments{
\item{data}{A dataframe containing the variables to analyze.}

\item{vars}{Character vector specifying which variables to include. Default: NULL.}

\item{method}{Character string specifying correlation method: "pearson" or "spearman". Default: "pearson".}

\item{type}{Character string specifying matrix type: "full", "upper", or "lower". Default: "full".}

\item{colors}{Character vector of 3 colors for negative, neutral, and positive correlations. Default: NULL.}

\item{title}{Character string for plot title. Default: NULL.}

\item{show_values}{Logical parameter indicating whether to display correlation values in cells. Default: TRUE.}

\item{value_size}{Numeric value indicating size of correlation value text. Default: 3.}

\item{show_sig}{Logical parameter indicating whether to mark significant correlations. Default: FALSE.}

\item{sig_level}{Numeric value indicating significance level for marking. Default: 0.05.}

\item{sig_only}{Logical parameter indicating whether to show only statistically significant values. Default: FALSE.}

\item{show_legend}{Logical parameter indicating whether to show legend. Default: TRUE.}

\item{p_method}{Character string specifying the method for p-value adjustment to control
for multiple comparisons in correlation testing. Options: "holm" (Holm), "hochberg" (Hochberg), "hommel" (Hommel),
"bonferroni" (Bonferroni), "BH" (Benjamini-Hochberg), "BY" (Benjamini-Yekutieli), or "none" (no adjustment).
Default: "holm".}
}
\value{
A ggplot2 object
}
\description{
Generates publication-ready correlation matrix heatmaps with minimal code using ggplot2.
}
\examples{
# Correlation matrix for base R dataset 'swiss'
plot_corr(data = swiss)

# Lower triangle with significance indicators and filtering
plot_corr(data = swiss, type = "lower", show_sig = TRUE, sig_only = TRUE)

}
