% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.gPLS.R, R/predict.pls.cox.R,
%   R/predict.sPLS.R, R/predict.sgPLS.R
\name{predict_pls_latent}
\alias{predict_pls_latent}
\alias{predict.gPLS}
\alias{predict.pls.cox}
\alias{predict.sPLS}
\alias{predict.sgPLS}
\title{Predict responses and latent scores from PLS fits}
\usage{
\method{predict}{gPLS}(object, newdata, scale.X = TRUE, scale.Y = TRUE, ...)

\method{predict}{pls.cox}(object, newdata, scale.X = TRUE, scale.Y = TRUE, ...)

\method{predict}{sPLS}(object, newdata, scale.X = TRUE, scale.Y = TRUE, ...)

\method{predict}{sgPLS}(object, newdata, scale.X = TRUE, scale.Y = TRUE, ...)
}
\arguments{
\item{object}{A fitted PLS model returned by \code{\link[sgPLS:gPLS]{sgPLS::gPLS()}},
\code{\link[sgPLS:sPLS]{sgPLS::sPLS()}}, \code{\link[sgPLS:sgPLS]{sgPLS::sgPLS()}}, or \code{\link[plsRcox:internal-plsRcox]{plsRcox::pls.cox()}}.}

\item{newdata}{Numeric matrix or data frame with the same number of columns
as the training design matrix used when fitting \code{object}.}

\item{scale.X, scale.Y}{Logical flags indicating whether the predictors and
responses supplied in \code{newdata} should be centred and scaled according to
the training statistics stored in \code{object}.}

\item{...}{Unused arguments included for compatibility with the generic
\code{\link[stats:predict]{stats::predict()}} signature.}
}
\value{
A list containing reconstructed responses, latent component scores,
and regression coefficients. The exact elements depend on the specific PLS
algorithm but always include components named \code{predict}, \code{variates}, and
\code{B.hat}.
}
\description{
These prediction helpers reconstruct the response matrix and latent
component scores for partial least squares (PLS) models fitted inside the
Cox-PLS toolbox. They support group PLS, sparse PLS, sparse-group PLS, and
classical PLS models created by \code{\link[sgPLS:gPLS]{sgPLS::gPLS()}}, \code{\link[sgPLS:sPLS]{sgPLS::sPLS()}},
\code{\link[sgPLS:sgPLS]{sgPLS::sgPLS()}}, or \code{\link[plsRcox:internal-plsRcox]{plsRcox::pls.cox()}}.
}
\examples{

n <- 100
sigma.gamma <- 1
sigma.e <- 1.5
p <- 400
q <- 500
theta.x1 <- c(rep(1, 15), rep(0, 5), rep(-1, 15), rep(0, 5), rep(1.5,15), 
              rep(0, 5), rep(-1.5, 15), rep(0, 325))
theta.x2 <- c(rep(0, 320), rep(1, 15), rep(0, 5), rep(-1, 15), rep(0, 5),
              rep(1.5, 15), rep(0, 5), rep(-1.5, 15), rep(0, 5))
theta.y1 <- 1
theta.y2 <- 1

Sigmax <- matrix(0, nrow = p, ncol = p)
diag(Sigmax) <- sigma.e ^ 2
Sigmay <- matrix(0,nrow = 1, ncol = 1)
diag(Sigmay) <- sigma.e ^ 2

set.seed(125)

gam1 <- rnorm(n)
gam2 <- rnorm(n)

X <- matrix(c(gam1, gam2), ncol = 2, byrow = FALSE) \%*\% matrix(c(theta.x1, theta.x2),
 nrow = 2, byrow = TRUE) + mvtnorm::rmvnorm(n, mean = rep(0, p), sigma =
 Sigmax, method = "svd")
Y <- matrix(c(gam1, gam2), ncol = 2, byrow = FALSE) \%*\% matrix(c(theta.y1, theta.y2), 
nrow = 2, byrow = TRUE) + rnorm(n,0,sd=sigma.e)

ind.block.x <- seq(20, 380, 20)

model.gPLS <- sgPLS::gPLS(X, Y, ncomp = 2, mode = "regression", keepX = c(4, 4), 
                   keepY = c(4, 4), ind.block.x = ind.block.x)
head(predict(model.gPLS, newdata = X)$variates)

}
\references{
Bastien, P., Bertrand, F., Meyer, N., & Maumy-Bertrand, M. (2015).
Deviance residuals-based sparse PLS and sparse kernel PLS for censored
data. \emph{Bioinformatics}, 31(3), 397–404. \url{doi:10.1093/bioinformatics/btu660}
}
\seealso{
\code{\link[=coxgpls]{coxgpls()}}, \code{\link[=coxsgpls]{coxsgpls()}}, \code{\link[=coxspls_sgpls]{coxspls_sgpls()}}, and
\code{\link[=coxDKgplsDR]{coxDKgplsDR()}} for Cox model wrappers that return PLS fits using these
prediction methods.
}
