% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/events.R
\name{read_events.bids_project}
\alias{read_events.bids_project}
\title{Read event files from a BIDS project}
\usage{
\method{read_events}{bids_project}(x, subid = ".*", task = ".*", run = ".*", session = ".*", ...)
}
\arguments{
\item{x}{A \code{bids_project} object.}

\item{subid}{Regex pattern to match subject IDs. Default is ".*" (all subjects).}

\item{task}{Regex pattern to match tasks. Default is ".*" (all tasks).}

\item{run}{Regex pattern to match runs. Default is ".*" (all runs).}

\item{session}{Regex pattern to match sessions. Default is ".*" (all sessions).}

\item{...}{Additional arguments passed to \code{event_files}.}
}
\value{
A nested tibble with columns:
\itemize{
\item \code{.task}: Task name
\item \code{.session}: Session ID (if present)
\item \code{.run}: Run number
\item \code{.subid}: Subject ID
\item \code{data}: A nested tibble containing the event data with columns:
\itemize{
\item \code{onset}: Event onset time in seconds
\item \code{duration}: Event duration in seconds
\item Additional task-specific columns (e.g., trial type, response, accuracy)
If no matching data is found, returns an empty tibble with appropriate columns.
Run and session identifiers are parsed from filenames using \code{func_parser()}.
}
}
}
\description{
Reads and nests event files for given subjects and tasks from a \code{bids_project} object.
Returns a nested tibble with event data grouped by task, session, run, and subject. Event files
typically contain trial-by-trial information for task-based fMRI data, including onset times,
durations, trial types, and other task-specific variables.
}
\examples{
\donttest{
# Create a BIDS project object
tryCatch({
  ds001_path <- get_example_bids_dataset("ds001")
  proj <- bids_project(ds001_path)
  
  # Read all event files
  all_events <- read_events(proj)
  
  # Read events for a specific subject and task
  sub01_events <- read_events(proj, 
                            subid="01", 
                            task="balloonanalogrisktask")
  
  # Read events for multiple subjects and a specific run
  multi_sub_events <- read_events(proj, 
                                subid="0[1-3]", 
                                run="01")
  
  # Access nested data for analysis
  if (nrow(sub01_events) > 0) {
    # Get first subject's data
    first_sub_data <- sub01_events$data[[1]]
    
    # Calculate mean trial duration
    mean_duration <- mean(first_sub_data$duration)
  }
  
  # Clean up
  unlink(ds001_path, recursive=TRUE)
}, error = function(e) {
  message("Example requires internet connection: ", e$message)
})
}
}
