% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_generic.R
\name{create_preproc_mask}
\alias{create_preproc_mask}
\title{Create a preprocessing mask from BIDS data}
\usage{
create_preproc_mask(x, subid, thresh = 0.99, ...)
}
\arguments{
\item{x}{A bids_project object}

\item{subid}{A regular expression pattern to match subject IDs}

\item{thresh}{Threshold value for mask creation (default: 0.99)}

\item{...}{Additional arguments passed to methods}
}
\value{
A logical mask volume
}
\description{
Create a preprocessing mask from BIDS data
}
\examples{
\donttest{
# Download and load a BIDS project with fMRIPrep derivatives
tryCatch({
  ds001_deriv_path <- get_example_bids_dataset("ds000001-fmriprep")
  proj <- bids_project(ds001_deriv_path, fmriprep=TRUE)
  mask <- create_preproc_mask(proj, subid=".*")
  
  # Create mask for single subject
  sub01_mask <- create_preproc_mask(proj, subid="01")
  
  # Clean up
  unlink(ds001_deriv_path, recursive=TRUE)
}, error = function(e) {
  message("Example requires derivatives dataset: ", e$message)
})
}
}
