% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_predict.R
\name{simulate.bgms}
\alias{simulate.bgms}
\title{Simulate Data from a Fitted bgms Model}
\usage{
\method{simulate}{bgms}(
  object,
  nsim = 500,
  seed = NULL,
  method = c("posterior-mean", "posterior-sample"),
  ndraws = NULL,
  iter = 1000,
  cores = parallel::detectCores(),
  display_progress = c("per-chain", "total", "none"),
  ...
)
}
\arguments{
\item{object}{An object of class \code{bgms}.}

\item{nsim}{Number of observations to simulate. Default: \code{500}.}

\item{seed}{Optional random seed for reproducibility.}

\item{method}{Character string specifying which parameter estimates to use:
\describe{
  \item{\code{"posterior-mean"}}{Use posterior mean parameters (faster,
    single simulation).}
  \item{\code{"posterior-sample"}}{Sample from posterior draws, producing
    one dataset per draw (accounts for parameter uncertainty). This method
    uses parallel processing when \code{cores > 1}.}
}}

\item{ndraws}{Number of posterior draws to use when
\code{method = "posterior-sample"}. If \code{NULL}, uses all available draws.}

\item{iter}{Number of Gibbs iterations for equilibration before collecting
samples. Default: \code{1000}.}

\item{cores}{Number of CPU cores for parallel execution when
\code{method = "posterior-sample"}.
Default: \code{parallel::detectCores()}.}

\item{display_progress}{Character string specifying the type of progress bar.
Options: \code{"per-chain"}, \code{"total"}, \code{"none"}.
Default: \code{"per-chain"}.}

\item{...}{Additional arguments (currently ignored).}
}
\value{
If \code{method = "posterior-mean"}: A matrix with \code{nsim} rows and
\code{p} columns containing simulated observations.

If \code{method = "posterior-sample"}: A list of matrices, one per posterior
draw, each with \code{nsim} rows and \code{p} columns.
}
\description{
Generates new observations from the Markov Random Field model using the
estimated parameters from a fitted \code{bgms} object.
}
\details{
This function uses the estimated interaction and threshold parameters to
generate new data via Gibbs sampling. When \code{method = "posterior-sample"},
parameter uncertainty is propagated to the simulated data by using different
posterior draws. Parallel processing is available for this method via the
\code{cores} argument.
}
\examples{
\donttest{
# Fit a model
fit <- bgm(x = Wenchuan[, 1:5], chains = 2)

# Simulate 100 new observations using posterior means
new_data <- simulate(fit, nsim = 100)

# Simulate with parameter uncertainty (10 datasets)
new_data_list <- simulate(fit, nsim = 100, method = "posterior-sample", ndraws = 10)

# Use parallel processing for faster simulation
new_data_list <- simulate(fit, nsim = 100, method = "posterior-sample",
                          ndraws = 100, cores = 2)
}

}
\seealso{
\code{\link{predict.bgms}} for computing conditional probabilities,
  \code{\link{simulate_mrf}} for simulation with user-specified parameters.
}
