% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_and_apply_uncertainty.R
\name{estimate_and_apply_uncertainty}
\alias{estimate_and_apply_uncertainty}
\title{Estimate and apply uncertainty to a point nowcast matrix}
\usage{
estimate_and_apply_uncertainty(
  point_nowcast_matrix,
  reporting_triangle,
  n_history_delay,
  n_retrospective_nowcasts,
  structure = get_reporting_structure(reporting_triangle),
  draws = 1000,
  delay_pmf = NULL,
  uncertainty_model = fit_by_horizon,
  uncertainty_sampler = sample_nb,
  validate = TRUE,
  ...
)
}
\arguments{
\item{point_nowcast_matrix}{Matrix of point nowcast predictions and
observations, with rows representing the reference times and columns
representing the delays.}

\item{reporting_triangle}{A \link{reporting_triangle} object with rows
representing reference times and columns representing delays.
Can be a reporting matrix or incomplete reporting matrix.
Can also be a ragged reporting triangle, where multiple columns are
reported for the same row (e.g., weekly reporting of daily data).}

\item{n_history_delay}{Integer indicating the number of reference times
(observations) to be used in the estimate of the reporting delay, always
starting from the most recent reporting delay.}

\item{n_retrospective_nowcasts}{Integer indicating the number of
retrospective nowcast times to use for uncertainty estimation.}

\item{structure}{Integer or vector specifying the reporting structure.
If integer, divides columns evenly by that integer (with last possibly
truncated).  If vector, the sum must not be greater than or equal to the
number of columns. Default is 1 (standard triangular structure).}

\item{draws}{Integer indicating the number of draws of the predicted
nowcast vector to generate. Default is \code{1000}.}

\item{delay_pmf}{Vector or list of vectors of delays assumed to be indexed
starting at the first delay column in each of the matrices in
\code{retro_reporting_triangles}. If a list, must be of the same length as
\code{retro_reporting_triangles}, with elements aligning. Default is \code{NULL}.}

\item{uncertainty_model}{Function that ingests a matrix of observations and a
matrix of predictions and returns a vector that can be used to
apply uncertainty using the same error model. Default is
\code{fit_by_horizon} with arguments of \code{obs} matrix of observations and
\code{pred} the matrix of predictions that fits each column (horizon)
to a negative binomial observation model by default. The user can
specify a different fitting model by replacing the
\code{fit_model} argument in \code{fit_by_horizon}.}

\item{uncertainty_sampler}{Function that ingests a vector or matrix of
predictions and a vector of uncertainty parameters and generates draws
from the observation model. Default is \code{sample_nb} which expects
arguments \code{pred} for the vector of predictions and uncertainty parameters
for the corresponding vector of uncertainty parameters, and draws from a
negative binomial for each element of the vector.}

\item{validate}{Logical. If TRUE (default), validates the object. Set to
FALSE only when called from functions that already validated.}

\item{...}{Additional arguments to \code{estimate_uncertainty()} and
\code{sample_prediction()}.}
}
\value{
\code{nowcast_draws_df} Dataframe containing draws of combined
observations and probabilistic predictions at each reference time.
}
\description{
Generates probabilistic nowcasts by estimating uncertainty parameters from
retrospective nowcasts and applying them to a point nowcast matrix.

This function combines:
\enumerate{
\item \code{\link[=estimate_uncertainty_retro]{estimate_uncertainty_retro()}} - Estimates uncertainty parameters
using retrospective nowcasts
\item \code{\link[=sample_nowcasts]{sample_nowcasts()}} - Applies uncertainty to generate draws
}

To obtain estimates of uncertainty parameters, use
\code{\link[=estimate_uncertainty_retro]{estimate_uncertainty_retro()}}. For full control over individual steps
(e.g., custom matrix preparation, alternative aggregation), use the
low-level functions (\code{\link[=truncate_to_rows]{truncate_to_rows()}},
\code{\link[=apply_reporting_structures]{apply_reporting_structures()}}, \code{\link[=estimate_and_apply_delays]{estimate_and_apply_delays()}},
\code{\link[=estimate_uncertainty]{estimate_uncertainty()}}) directly.
}
\examples{
# Use package data truncated to appropriate size
data_as_of <- syn_nssp_df[syn_nssp_df$report_date <= "2026-04-01", ]
triangle <- as_reporting_triangle(data_as_of) |>
  truncate_to_delay(max_delay = 25)

pt_nowcast_matrix <- estimate_and_apply_delay(
  reporting_triangle = triangle,
  n = 75
)
# Use 75 reference times for delay estimation and 40 for uncertainty
nowcast_draws_df <- estimate_and_apply_uncertainty(
  pt_nowcast_matrix,
  triangle,
  n_history_delay = 75,
  n_retrospective_nowcasts = 40,
  draws = 100
)
head(nowcast_draws_df)
}
\seealso{
High-level workflow wrapper functions
\code{\link{allocate_reference_times}()},
\code{\link{estimate_and_apply_delay}()},
\code{\link{estimate_and_apply_delays}()},
\code{\link{estimate_uncertainty_retro}()}
}
\concept{workflow_wrappers}
