% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_data.R
\name{load_stratdata_indiv}
\alias{load_stratdata_indiv}
\title{Load stratigraphic data from individual tables}
\usage{
load_stratdata_indiv(
  stations_upload,
  sections_upload,
  layers_upload,
  samples_upload = NULL,
  verbose = TRUE
)
}
\arguments{
\item{stations_upload}{A data frame with "station" metadata. The
following columns are required in order to work with \code{avstrat} functions:
\itemize{
\item \code{station_id}: UniqueID for the station.
\item \code{latdd}: Location in decimal degrees, in WGS84 datum.
\item \code{longdd}: Longitude in decimal degrees, in WGS84 datum.
}}

\item{sections_upload}{A data frame with "section" metadata (point to same
file as station_upload if already joined). The following columns are required
in order to work with \code{avstrat} functions:
\itemize{
\item \code{station_id}: UniqueID for the station, must match an existing value in station_upload.
\item \code{stratsection_name}: Unique identity of the section.
\item \code{stratmeasuremethod}: One of \code{"order and thickness"} or \code{"start and stop depth"}.
\item \code{stratlayer_order_start_at_top}: Logical, does ordering start at the top (\code{TRUE}) or bottom (\code{FALSE})? For "start and stop depth", this defines if the reference "depth" is the top or bottom of the section.
}}

\item{layers_upload}{A data frame with "layer" metadata. The following columns are required
in order to work with \code{avstrat} functions:
\itemize{
\item \code{stratsection_name}: Unique identity of the section, must match an existing value in section_upload.
\item \code{stratlayer_name}: Unique identifier for the layer.
\item \code{layer_type}: A character value from a list for plotting default layer symbols (color). If not provided,
plotting functions will need to override default layer_fill mapping. Must be chosen from a validated list:
\itemize{
\item \code{volcanic}
\item \verb{tephra fall}
\item \code{lava}
\item \code{intrusion}
\item \code{tuff}
\item \code{sediment}
\item \code{soil}
\item \code{peat}
\item \code{lacustrine}
\item \code{fluvial}
\item \code{eolian}
\item \code{diamict}
\item \code{clay}
\item \verb{pyroclastic density current}
\item \verb{pyroclastic surge}
\item \verb{pyroclastic flow}
\item \verb{mass wasting}
\item \verb{debris flow}
\item \code{lahar}
\item \code{landslide}
\item \verb{hyperconcentrated flow}
\item \verb{debris avalanche}
\item \verb{frozen water}
\item \code{ice}
\item \code{snow}
\item \verb{dirty snow}
\item \code{plant}
\item \code{rock}
\item \code{other}
\item \code{undifferentiated/undescribed}
}
\item \code{grainsize_top}: Grain size at the top of the layer.
\item \code{grainsize_bottom}: Grain size at the bottom of the layer.
}

Grain size values must be chosen from the validated list (White & Houghton,
2006, \emph{Geology} 34:677–680):
\itemize{
\item \code{"clay"} (<1/256 mm)
\item \code{"silt"} (1/256-1/16 mm)
\item \code{"very fine sand/ash"} (1/16-1/8 mm)
\item \code{"fine sand/ash"} (1/8-1/4 mm)
\item \code{"medium sand/ash"} (1/4-1/2 mm)
\item \code{"coarse sand/ash"} (1/2-1 mm)
\item \code{"very coarse sand/ash"} (1-2 mm)
\item \code{"granule/fine lapilli"} (2-4 mm)
\item \code{"pebble/medium lapilli"} (4-16 mm)
\item \code{"cobble/coarse lapilli"} (1.6-6.4 cm)
\item \code{"blocks/bombs/boulders"} (>6.4 cm)
\item \code{NA} (no data)
}
\strong{If \code{stratmeasuremethod == "order and thickness"}}
\itemize{
\item \code{stratlayer_order}: Integer order of layers within the section.
\item \code{thickness_units}: One of \code{"meters"}, \code{"centimeters"}, \code{"millimeters"}.
\item \code{thickness_typical}: Numeric value of the typical thickness of a layer.
\item \code{thickness_min}: Numeric value of the minimum thickness of a layer.
\item \code{thickness_max}: Numeric value of the maximum thickness of a layer.
\strong{If \code{stratmeasuremethod == "start and stop depth"}}
\item \code{depth_units}: One of \code{"meters"}, \code{"centimeters"}, \code{"millimeters"}.
\item \code{depth_top}: Absolute depth of the top of the layer.
\item \code{depth_bottom}: Absolute depth of the bottom of the layer.
}}

\item{samples_upload}{A data frame with "sample" metadata.
\itemize{
\item \code{stratlayer_name}: Unique identifier for the layer, must match an existing value in layer_upload.
\item \code{SampleID}: Unique identifier for the sample.
}}

\item{verbose}{Logical. If TRUE (default), prints a message listing the
imported stratigraphic sections. Set to FALSE to suppress console output.}
}
\value{
A data frame of layers joined with section and station metadata,
plus collapsed sample information:
\itemize{
\item \code{stratlayer_sample}: concatenated \code{SampleID}s per layer (separated by \code{"|"}).
\item \code{SampleID}: list column of \code{SampleID}s per layer.
}
}
\description{
\code{load_stratdata_indiv()} loads necessary data for \code{avstrat} from separate
station (location), section (section metadata), stratlayer, and sample data.
Allows upload of smaller number of tables if data are already joined together
(e.g., stations-sections combined, or layers-samples combined). The function
also extracts and, optionally, prints a list of unique stratigraphic sections.
}
\examples{
# Locate the example Excel files shipped with the package
path <- system.file("extdata", "example_inputs.xlsx",
  package = "avstrat"
)

# Read them with readxl
library(readxl)
  stations <- readxl::read_xlsx(path, sheet = "stations")
  sections <- readxl::read_xlsx(path, sheet = "sections")
  layers <- readxl::read_xlsx(path, sheet = "layers")
  samples <- readxl::read_xlsx(path, sheet = "samples_layer")

  load_stratdata_indiv(stations_upload = stations,
                       sections_upload = sections,
                       layers_upload = layers,
                       samples_upload = samples)

}
