\name{ENSO}
\alias{ENSO}
\docType{data}
\title{El Nino - Southern Oscillation Index
}
\description{
Southern Oscillation Index (SOI), 1/1951 to 10/2022; anomalies are departures from the 1981-2010 base period.
}
\format{
  The format is:
 Time-Series [1:862] from 1951 to 2022:  2.0 1.1 -0.3 -0.8 -1.1 -0.7 -1.5 -0.3 -0.7 -0.7
 ...
}
\details{
The \eqn{\textrm{El Ni\~no - Southern Oscillation (ENSO)}} is a recurring climate pattern involving changes in the temperature of waters in the central and eastern tropical Pacific Ocean.  This data set is an update to \code{\link{soi}}.
}
\source{
\kbd{https://www.ncei.noaa.gov/access/monitoring/enso/soi}
}
\references{You can find demonstrations of  astsa capabilities at  
\href{https://github.com/nickpoison/astsa/blob/master/fun_with_astsa/fun_with_astsa.md}{FUN WITH ASTSA}.

The most recent version of the package can be found  at \url{https://github.com/nickpoison/astsa/}.

In addition, the News and ChangeLog files are at  \url{https://github.com/nickpoison/astsa/blob/master/NEWS.md}.

The webpages for the texts and some help on using R for time series analysis can be found at
 \url{https://nickpoison.github.io/}.  
}
\seealso{\code{\link{soi}, \link{ENSO}, \link{MEI}, \link{MEI2}}
}
\examples{
# ENSO is a standardized index based on the sea level pressure differences between 
# Tahiti and Darwin, Australia.  MEI is a similar index based on multiple factors.
# As opposed to ENSO (and SOI), positive values of MEI correspond to warmer temperatures.

tsplot(cbind(-ENSO, MEI), col=astsa.col(2*2:1, .6), addLegend=TRUE, spag=TRUE, lwd=1:2)

tspairs(ts.intersect(-ENSO, MEI), location='top')

}
\keyword{datasets}
