% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apsis.R
\name{next_planet_apsis}
\alias{next_planet_apsis}
\title{Find the next planetary apsis in a series}
\usage{
next_planet_apsis(body, apsis)
}
\arguments{
\item{body}{Integer constant identifying the planet. Use \code{astro_body["PLANET_NAME"]}
where \code{PLANET_NAME} is one of: \code{"MERCURY"}, \code{"VENUS"}, \code{"EARTH"}, \code{"MARS"},
\code{"JUPITER"}, \code{"SATURN"}, \code{"URANUS"}, \code{"NEPTUNE"}, or \code{"PLUTO"}.
Must match the body passed into the call that produced the \code{apsis} parameter.
Not allowed to be \code{"SUN"} or \code{"MOON"}.}

\item{apsis}{An apsis event (a list) obtained from a call to
\code{search_planet_apsis()} or \code{next_planet_apsis()}.}
}
\value{
A list with the same structure as returned by \code{search_planet_apsis()}:
\describe{
\item{kind}{An integer flag: 0 for perihelion, 1 for aphelion.}
\item{time}{A \code{POSIXct} value representing the date and time of the
next planetary apsis.}
\item{dist_au}{The distance from the planet to the Sun in astronomical units.}
\item{dist_km}{The distance from the planet to the Sun in kilometers.}
}
}
\description{
Given an aphelion event, this function finds the next perihelion event,
and vice versa. This requires an apsis event obtained from a call to
\code{search_planet_apsis()} or a previous call to \code{next_planet_apsis()}.
}
\examples{
# Find successive apsis events for Mars
start <- as.POSIXct("2025-01-01", tz = "UTC")
apsis1 <- search_planet_apsis(astro_body["MARS"], start)
apsis2 <- next_planet_apsis(astro_body["MARS"], apsis1)
apsis3 <- next_planet_apsis(astro_body["MARS"], apsis2)
}
\seealso{
\code{\link[=search_planet_apsis]{search_planet_apsis()}}
}
