% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rise_set_culmination.R
\name{astro_search_rise_set}
\alias{astro_search_rise_set}
\title{Search for the next rise or set time of a celestial body}
\usage{
astro_search_rise_set(
  body,
  time,
  latitude,
  longitude,
  height = 0,
  direction = 1L,
  limit_days = 1,
  meters_above_ground = 0
)
}
\arguments{
\item{body}{Integer body code (see \link{astro_body}).}

\item{time}{A \code{POSIXct} date/time in UTC to start the search from.}

\item{latitude}{Observer's geographic latitude in degrees.}

\item{longitude}{Observer's geographic longitude in degrees.}

\item{height}{Observer's height above sea level in metres. Default \code{0}.}

\item{direction}{\code{1L} to find the next rise, \code{-1L} to find the next set.
Default \code{1L} (rise).}

\item{limit_days}{Maximum number of days to search. When positive, searches
forward in time; when negative, searches backward. Default \code{1}.}

\item{meters_above_ground}{Height of observer above the ground (not sea
level) in metres, for computing the dip of the horizon. Default \code{0}.}
}
\value{
A \code{POSIXct} value in UTC, or \code{NA} if no event is found within
\code{limit_days}.
}
\description{
Searches for the next time a celestial body rises or sets as seen by an
observer on the Earth. Rise time is when the body first starts to be visible
above the horizon. Set time is when the body appears to vanish below the
horizon. This function adjusts for the apparent angular radius of the
observed body (significant only for the Sun and Moon) and corrects for
atmospheric refraction.
}
\details{
Rise or set may not occur in every 24-hour period. For example, near the
Earth's poles, there are long periods where the Sun stays below the horizon,
never rising.
}
\examples{
t <- as.POSIXct("2025-06-21", tz = "UTC")
# Find next sunrise at Sydney Observatory
astro_search_rise_set(astro_body[["SUN"]], t,
                      latitude = -33.8688, longitude = 151.2093)
}
