% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visual.R
\name{astro_elongation}
\alias{astro_elongation}
\title{Elongation of a celestial body}
\usage{
astro_elongation(body, time)
}
\arguments{
\item{body}{Integer code identifying the celestial body.}

\item{time}{A POSIXct date-time value indicating the observation time.}
}
\value{
A list with the following elements:
\describe{
\item{visibility}{Integer flag indicating morning (0) or evening (1)
visibility.}
\item{elongation}{The angle in degrees between the Earth-Sun and
Earth-body vectors. Range: [0, 180].}
\item{ecliptic_separation}{The absolute difference in ecliptic longitude
between the body and the Sun. Range: [0, 180].}
\item{time}{A POSIXct value representing the observation time.}
\item{status}{Status code from the underlying C function.}
}
}
\description{
Determines visibility of a celestial body relative to the Sun, as seen from
the Earth. Returns information about the elongation angle and whether the
body is best observed in the morning or evening.
}
\examples{
time <- as.POSIXct("2025-06-15 12:00:00", tz = "UTC")
astro_elongation(body = astro_body["MERCURY"], time = time)
}
