% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fsrs_advanced.R
\name{fsrs_current_retrievability}
\alias{fsrs_current_retrievability}
\title{Calculate current retrievability for all cards}
\usage{
fsrs_current_retrievability(path = NULL, profile = NULL)
}
\arguments{
\item{path}{Path to collection.anki2 (auto-detected if NULL)}

\item{profile}{Profile name (first profile if NULL)}
}
\value{
A tibble with cards and their current retrievability
}
\description{
Computes the current probability of recall for all FSRS-enabled cards.
}
\examples{
\dontrun{
r <- fsrs_current_retrievability()
# Cards with low retrievability need review soon
r[r$retrievability < 0.8, ]
}
}
