% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/av_api_key.R
\name{av_api_key}
\alias{av_api_key}
\title{Set the Alpha Vantage API Key}
\usage{
av_api_key(api_key, entitlement = NULL)
}
\arguments{
\item{api_key}{A character string with your Alpha Vantage API Key.}

\item{entitlement}{A character string with your Alpha Vantage entitlement status.  If not "delayed" or "realtime" entitlement not added to API string.}
}
\value{
Invisibly returns two item list with API key and entitlement string once set). Use print method to view.
}
\description{
\code{av_api_key()} sets Alphavantage API key and entitlement code
}
\details{
The Alpha Vantage API key must be set prior to using \code{\link[=av_get_pf]{av_get_pf()}}. You can obtain
an API key at the \href{https://www.alphavantage.co/}{Alpha Vantage Website}.
}
\examples{
\dontrun{
av_api_key("YOUR_API_KEY",entitlement="delayed")
av_get_pf("IBM", "TIME_SERIES_INTRADAY")
}

}
\seealso{
\code{\link[=av_get_pf]{av_get_pf()}}
}
