% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_airnow_area.R
\name{get_airnow_area}
\alias{get_airnow_area}
\title{Get air quality data for a given region}
\usage{
get_airnow_area(
  box,
  parameters = "pm25",
  start_time = NULL,
  end_time = NULL,
  monitor_type = "both",
  data_type = c("aqi", "concentrations", "both"),
  verbose = FALSE,
  raw_concentrations = FALSE,
  clean_names = TRUE,
  api_key = get_airnow_token()
)
}
\arguments{
\item{box}{Four-element numeric vector specifying a bounding box for the
region of interest. Format is (minX, minY, maxX, maxY), where X and Y are
longitude and latitude, respectively.}

\item{parameters}{Parameter(s) to return data for. Choices are PM_\{2.5\}
(\code{pm25}: default), \code{ozone}, PM_10 (\code{pm10}), CO (\code{co}), NO2 (\code{no2}), and
SO2 (\code{so2}).}

\item{start_time}{Optional. The date and time (UTC) at the start of the time
period requested. If specified, \code{end_time} must also be given. If not
specified, the most recent past hour is used.}

\item{end_time}{Optional. The date and time (UTC) at the end of the time
period requested. If specified, \code{start_time} must also be given. If not
specified, the following hour is used.}

\item{monitor_type}{Type of monitor to be returned, either \code{"permanent"},
\code{"mobile"}, or \code{"both"} (default).}

\item{data_type}{Type of data to be returned, either \code{"aqi"} (default),
\code{"concentrations"}, or \code{"both"}.}

\item{verbose}{Logical value indicating whether or not to include additional
site information including Site Name, Agency Name, AQS ID, and Full AQS ID
(default: \code{FALSE})}

\item{raw_concentrations}{Logical value indicating whether or not raw
hourly concentration data should be included (default: \code{FALSE})}

\item{clean_names}{Whether or not column names should be cleaned (default:
\code{TRUE})}

\item{api_key}{AirNow API key}
}
\value{
A data frame with current air quality conditions
}
\description{
\code{get_airnow_area()} retrieves the most recent air quality readings from sites
in a specified region.
}
\examples{
\dontrun{
# Get air quality data around Washington state
get_airnow_area(box = c(-125.394211, 45.295897, -116.736984, 49.172497))
}
}
