% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrappers.R
\name{f4ratio}
\alias{f4ratio}
\alias{d}
\alias{f4}
\alias{f3}
\title{Calculate the D, f4, f4-ratio, or f3 statistic.}
\usage{
f4ratio(data, X, A, B, C, O, outdir = NULL, params = NULL)

d(
  data,
  W,
  X,
  Y,
  Z,
  quartets = NULL,
  outdir = NULL,
  f4mode = FALSE,
  params = NULL
)

f4(data, W, X, Y, Z, quartets = NULL, outdir = NULL, params = NULL)

f3(data, A, B, C, outdir = NULL, inbreed = FALSE, params = NULL)
}
\arguments{
\item{data}{EIGENSTRAT data object.}

\item{outdir}{Where to put all generated files (temporary directory by default).}

\item{params}{Named list of parameters and their values. For instance,
\code{params = list(allsnps = "YES")} or \code{params = list(blgsize = 0.01)}
(or an arbitrary combination of parameters using a list with multiple named
elements).}

\item{W, X, Y, Z, A, B, C, O}{Population names according to the nomenclature used in
Patterson et al., 2012.}

\item{quartets}{List of character vectors (quartets of population/sample labels)}

\item{f4mode}{Calculate the f4 statistic instead of the D statistic.}

\item{inbreed}{See README.3PopTest in ADMIXTOOLS for an explanation.}
}
\value{
Data frame object with calculated statistics
}
\description{
Calculate the D, f4, f4-ratio, or f3 statistic.
}
\examples{
\dontrun{# download an example genomic data set and prepare it for analysis
snps <- eigenstrat(download_data(dirname = tempdir()))

# define a set of populations to analyze
pops <- c("French", "Sardinian", "Han", "Papuan", "Dinka")

result_f4ratio <- f4ratio(
    X = pops, A = "Altai", B = "Vindija", C = "Yoruba", O = "Chimp",
    data = snps
)

result_d <- d(
    W = pops, X = "Yoruba", Y = "Vindija", Z = "Chimp",
    data = snps
)

result_f4 <- f4(
    W = pops, X = "Yoruba", Y = "Vindija", Z = "Chimp",
    data = snps
)

result_f3 <- f3(
    A = pops, B = "Mbuti", C = "Khomani_San",
    data = snps
)
}

}
