% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{sm_get_indexed_keywords}
\alias{sm_get_indexed_keywords}
\title{Get Indexed Keywords from Scopus}
\usage{
sm_get_indexed_keywords(doi = NA, eid = NA, verbose = FALSE)
}
\arguments{
\item{doi}{Character string containing the paper's DOI.}

\item{eid}{Character string containing the paper's EID (Scopus identifier).}

\item{verbose}{Logical indicating whether to print error messages.
Default is FALSE.}
}
\value{
Character string of indexed keywords separated by " | ", or NA if
  not available.
}
\description{
Retrieves indexed keywords for a single paper using its DOI or EID.
This function makes an additional API call per paper, so use judiciously.
}
\examples{
\dontrun{
# Requires Scopus API key
keywords <- sm_get_indexed_keywords(
  doi = "10.1016/j.jsams.2020.01.001"
)
}
}
