% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/module-dependencies-methods.R
\name{depsEdgeList}
\alias{depsEdgeList}
\alias{depsEdgeList,simList,logical-method}
\alias{depsEdgeList,simList,missing-method}
\title{Build edge list for module dependency graph}
\usage{
depsEdgeList(sim, plot, includeOutputs = FALSE)

\S4method{depsEdgeList}{simList,logical}(sim, plot, includeOutputs = FALSE)

\S4method{depsEdgeList}{simList,missing}(sim, plot)
}
\arguments{
\item{sim}{A \code{simList} object.}

\item{plot}{Logical indicating whether the edgelist (and subsequent graph)
will be used for plotting. If \code{TRUE}, duplicated rows
(i.e., multiple object dependencies between modules) are removed
so that only a single arrow is drawn connecting the modules.
Default is \code{FALSE}.}

\item{includeOutputs}{Logical indicating whether objects that are only "outputs"
will be kept and labelled as \emph{OUTPUTS} analogous to \emph{INPUTS}. This is relevant
in the case of \code{objectSynonyms}. If an object is not used by another module
then it will be removed from this \code{depsEdgeList} return; this keeps these
so can be determined if they are e.g., \code{suppliedElsewhere}.}
}
\value{
A \code{data.table} whose first two columns give a list of edges
and remaining columns the attributes of the dependency objects
(object name, class, etc.).
}
\description{
Build edge list for module dependency graph
}
\author{
Alex Chubaty
}
